/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.Expression;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.StrictListAccessor;
import lombok.ast.StringLiteral;

public class NonInternationalizedSmsDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create((String)"UnlocalizedSms", (String)"SMS phone number missing country code", (String)"SMS destination numbers must start with a country code or the application code must ensure that the SMS is only sent when the user is in the same country as the receiver.", (Category)Category.CORRECTNESS, (int)5, (Severity)Severity.WARNING, (Implementation)new Implementation(NonInternationalizedSmsDetector.class, Scope.JAVA_FILE_SCOPE));

    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return true;
    }

    public List<String> getApplicableMethodNames() {
        ArrayList<String> methodNames = new ArrayList<String>(2);
        methodNames.add("sendTextMessage");
        methodNames.add("sendMultipartTextMessage");
        return methodNames;
    }

    public void visitMethod(@NonNull JavaContext context, @Nullable AstVisitor visitor, @NonNull MethodInvocation node) {
        String number;
        Expression destinationAddress;
        assert (node.astName().astValue().equals("sendTextMessage") || node.astName().astValue().equals("sendMultipartTextMessage"));
        if (node.astOperand() == null) {
            return;
        }
        StrictListAccessor args = node.astArguments();
        if (args.size() == 5 && (destinationAddress = (Expression)args.first()) instanceof StringLiteral && !(number = ((StringLiteral)destinationAddress).astValue()).startsWith("+")) {
            context.report(ISSUE, (Node)node, context.getLocation((Node)destinationAddress), "To make sure the SMS can be sent by all users, please start the SMS number with a + and a country code or restrict the code invocation to people in the country you are targeting.");
        }
    }
}

