/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DeprecationDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create((String)"Deprecated", (String)"Using deprecated resources", (String)"Deprecated views, attributes and so on are deprecated because there is a better way to do something. Do it that new way. You've been warned.", (Category)Category.CORRECTNESS, (int)2, (Severity)Severity.WARNING, (Implementation)new Implementation(DeprecationDetector.class, Scope.RESOURCE_FILE_SCOPE));

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public Collection<String> getApplicableElements() {
        return Collections.singletonList("AbsoluteLayout");
    }

    public Collection<String> getApplicableAttributes() {
        return Arrays.asList("editable", "inputMethod", "autoText", "capitalize", "numeric", "phoneNumber", "password");
    }

    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        context.report(ISSUE, (Node)element, context.getLocation((Node)element), String.format("`%1$s` is deprecated", element.getTagName()));
    }

    public void visitAttribute(@NonNull XmlContext context, @NonNull Attr attribute) {
        String fix;
        if (!"http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI())) {
            return;
        }
        String name = attribute.getLocalName();
        int minSdk = 1;
        if (name.equals("editable")) {
            fix = !"EditText".equals(attribute.getOwnerElement().getTagName()) ? "Use an `<EditText>` to make it editable" : ("true".equals(attribute.getValue()) ? "`<EditText>` is already editable" : "Use `inputType` instead");
        } else if (name.equals("enabled")) {
            fix = "Use `state_enabled` instead";
        } else if (name.equals("singleLine")) {
            fix = "Use `maxLines=\"1\"` instead";
        } else {
            assert (name.equals("inputMethod") || name.equals("capitalize") || name.equals("numeric") || name.equals("phoneNumber") || name.equals("password") || name.equals("autoText"));
            fix = "Use `inputType` instead";
            minSdk = 3;
        }
        if (context.getProject().getMinSdk() < minSdk) {
            return;
        }
        context.report(ISSUE, (Node)attribute, context.getLocation((Node)attribute), String.format("`%1$s` is deprecated: %2$s", attribute.getName(), fix));
    }
}

