/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.io.File;
import java.util.Collections;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.Expression;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.IntegralLiteral;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.Return;
import lombok.ast.StrictListAccessor;

public class ToastDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create((String)"ShowToast", (String)"Toast created but not shown", (String)"Looks for code creating a `Toast` but forgetting to call `show()` on it", (String)"`Toast.makeText()` creates a `Toast` but does *not* show it. You must call `show()` on the resulting object to actually make the `Toast` appear.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(ToastDetector.class, Scope.JAVA_FILE_SCOPE));

    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return true;
    }

    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("makeText");
    }

    public void visitMethod(@NonNull JavaContext context, @Nullable AstVisitor visitor, @NonNull MethodInvocation node) {
        Node method;
        Expression duration;
        assert (node.astName().astValue().equals("makeText"));
        if (node.astOperand() == null) {
            return;
        }
        String operand = node.astOperand().toString();
        if (!operand.equals("Toast") && !operand.endsWith(".Toast")) {
            return;
        }
        StrictListAccessor args = node.astArguments();
        if (args.size() == 3 && (duration = (Expression)args.last()) instanceof IntegralLiteral) {
            context.report(ISSUE, (Node)duration, context.getLocation((Node)duration), "Expected duration Toast.LENGTH_SHORT or Toast.LENGTH_LONG, a custom duration value is not supported", null);
        }
        if ((method = JavaContext.findSurroundingMethod((Node)node.getParent())) == null) {
            return;
        }
        ShowFinder finder = new ShowFinder(node);
        method.accept((AstVisitor)finder);
        if (!finder.isShowCalled()) {
            context.report(ISSUE, (Node)node, context.getLocation((Node)node), "Toast created but not shown: did you forget to call show() ?", null);
        }
    }

    private static class ShowFinder
    extends ForwardingAstVisitor {
        private final MethodInvocation mTarget;
        private boolean mFound;
        private boolean mSeenTarget;

        private ShowFinder(MethodInvocation target) {
            this.mTarget = target;
        }

        public boolean visitMethodInvocation(MethodInvocation node) {
            if (node == this.mTarget) {
                this.mSeenTarget = true;
            } else if ((this.mSeenTarget || node.astOperand() == this.mTarget) && "show".equals(node.astName().astValue())) {
                this.mFound = true;
            }
            return true;
        }

        public boolean visitReturn(Return node) {
            if (node.astValue() == this.mTarget) {
                this.mFound = true;
            }
            return super.visitReturn(node);
        }

        boolean isShowCalled() {
            return this.mFound;
        }
    }
}

