/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ManifestTypoDetector
extends Detector
implements Detector.XmlScanner {
    public static final Issue ISSUE = Issue.create((String)"ManifestTypo", (String)"Typos in manifest tags", (String)"Checks for manifest typos", (String)"This check looks through the manifest, and if it finds any tags that look like likely misspellings, they are flagged.", (Category)Category.CORRECTNESS, (int)5, (Severity)Severity.WARNING, (Implementation)new Implementation(ManifestTypoDetector.class, Scope.MANIFEST_SCOPE));
    private static final Set<String> sValidTags;
    private static final int MAX_EDIT_DISTANCE = 3;

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return file.getName().equals("AndroidManifest.xml");
    }

    public Collection<String> getApplicableElements() {
        return Detector.XmlScanner.ALL;
    }

    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        String tag = element.getTagName();
        if (!sValidTags.contains(tag)) {
            int tagLength = tag.length();
            List suggestions = null;
            for (String suggestion : sValidTags) {
                if (Math.abs(suggestion.length() - tagLength) > 3 || LintUtils.editDistance((String)suggestion, (String)tag) > 3) continue;
                if (suggestions == null) {
                    suggestions = Lists.newArrayList();
                }
                suggestions.add('<' + suggestion + '>');
            }
            if (suggestions != null) {
                assert (!suggestions.isEmpty());
                String suggestionString = suggestions.size() == 1 ? (String)suggestions.get(0) : (suggestions.size() == 2 ? String.format("%1$s or %2$s", suggestions.get(0), suggestions.get(1)) : LintUtils.formatList((List)suggestions, (int)-1));
                String message = String.format("Misspelled tag <%1$s>: Did you mean %2$s ?", tag, suggestionString);
                context.report(ISSUE, (Node)element, context.getLocation((Node)element), message, null);
            }
        }
    }

    static {
        int expectedSize = 30;
        sValidTags = Sets.newHashSetWithExpectedSize((int)expectedSize);
        sValidTags.add("manifest");
        sValidTags.add("application");
        sValidTags.add("activity");
        sValidTags.add("service");
        sValidTags.add("provider");
        sValidTags.add("receiver");
        sValidTags.add("uses-feature");
        sValidTags.add("uses-library");
        sValidTags.add("uses-sdk");
        sValidTags.add("instrumentation");
        sValidTags.add("uses-permission");
        sValidTags.add("permission");
        sValidTags.add("permission-tree");
        sValidTags.add("permission-group");
        sValidTags.add("uses-configuration");
        sValidTags.add("activity-alias");
        sValidTags.add("intent-filter");
        sValidTags.add("meta-data");
        sValidTags.add("action");
        sValidTags.add("category");
        sValidTags.add("data");
        sValidTags.add("grant-uri-permission");
        sValidTags.add("path-permission");
        sValidTags.add("supports-screens");
        sValidTags.add("compatible-screens");
        sValidTags.add("supports-gl-texture");
        sValidTags.add("eat-comment");
        sValidTags.add("original-package");
        sValidTags.add("protected-broadcast");
        sValidTags.add("adopt-permissions");
        assert (sValidTags.size() <= expectedSize) : sValidTags.size();
    }
}

