/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ApiClass;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ApiParser
extends DefaultHandler {
    private static final String NODE_API = "api";
    private static final String NODE_CLASS = "class";
    private static final String NODE_FIELD = "field";
    private static final String NODE_METHOD = "method";
    private static final String NODE_EXTENDS = "extends";
    private static final String NODE_IMPLEMENTS = "implements";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_SINCE = "since";
    private final Map<String, ApiClass> mClasses = new HashMap<String, ApiClass>();
    private ApiClass mCurrentClass;

    ApiParser() {
    }

    Map<String, ApiClass> getClasses() {
        return this.mClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (localName == null || localName.isEmpty()) {
            localName = qName;
        }
        try {
            if (NODE_API.equals(localName)) {
            } else if (NODE_CLASS.equals(localName)) {
                String name = attributes.getValue(ATTR_NAME);
                int since = Integer.parseInt(attributes.getValue(ATTR_SINCE));
                this.mCurrentClass = this.addClass(name, since);
            } else if (NODE_EXTENDS.equals(localName)) {
                String name = attributes.getValue(ATTR_NAME);
                int since = this.getSince(attributes);
                this.mCurrentClass.addSuperClass(name, since);
            } else if (NODE_IMPLEMENTS.equals(localName)) {
                String name = attributes.getValue(ATTR_NAME);
                int since = this.getSince(attributes);
                this.mCurrentClass.addInterface(name, since);
            } else if (NODE_METHOD.equals(localName)) {
                String name = attributes.getValue(ATTR_NAME);
                int since = this.getSince(attributes);
                this.mCurrentClass.addMethod(name, since);
            } else if (NODE_FIELD.equals(localName)) {
                String name = attributes.getValue(ATTR_NAME);
                int since = this.getSince(attributes);
                this.mCurrentClass.addField(name, since);
            }
        }
        finally {
            super.startElement(uri, localName, qName, attributes);
        }
    }

    private ApiClass addClass(String name, int apiLevel) {
        ApiClass theClass = this.mClasses.get(name);
        if (theClass == null) {
            theClass = new ApiClass(name, apiLevel);
            this.mClasses.put(name, theClass);
        }
        return theClass;
    }

    private int getSince(Attributes attributes) {
        int since = this.mCurrentClass.getSince();
        String sinceAttr = attributes.getValue(ATTR_SINCE);
        if (sinceAttr != null) {
            since = Integer.parseInt(sinceAttr);
        }
        return since;
    }
}

