/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.syntaxChecks;

import lombok.ast.AlternateConstructorInvocation;
import lombok.ast.AnnotationDeclaration;
import lombok.ast.AnnotationMethodDeclaration;
import lombok.ast.Break;
import lombok.ast.Case;
import lombok.ast.Catch;
import lombok.ast.ClassDeclaration;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.Continue;
import lombok.ast.Default;
import lombok.ast.DoWhile;
import lombok.ast.EmptyDeclaration;
import lombok.ast.EnumDeclaration;
import lombok.ast.For;
import lombok.ast.ForEach;
import lombok.ast.Identifier;
import lombok.ast.If;
import lombok.ast.InstanceInitializer;
import lombok.ast.InterfaceDeclaration;
import lombok.ast.MethodDeclaration;
import lombok.ast.Modifiers;
import lombok.ast.Return;
import lombok.ast.StaticInitializer;
import lombok.ast.SuperConstructorInvocation;
import lombok.ast.Switch;
import lombok.ast.Try;
import lombok.ast.TypeReference;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.While;
import lombok.ast.syntaxChecks.BasicChecks;
import lombok.ast.syntaxChecks.KeywordChecks;
import lombok.ast.syntaxChecks.StatementChecks;
import lombok.ast.syntaxChecks.StructuralChecks;
import lombok.ast.syntaxChecks.SyntacticValidityVisitorBase;
import lombok.ast.syntaxChecks.TypeChecks;
import lombok.ast.syntaxChecks.UnreachableStatementsChecks;

public class SyntacticValidityVisitor
extends SyntacticValidityVisitorBase {
    public SyntacticValidityVisitor(boolean recursing) {
        super(recursing);
    }

    @Override
    public boolean visitAlternateConstructorInvocation(AlternateConstructorInvocation node) {
        this.getCheckerObject(StructuralChecks.class).alternateConstructorInvocationMustBeFirst(node);
        return !this.recursing;
    }

    @Override
    public boolean visitAnnotationDeclaration(AnnotationDeclaration node) {
        this.getCheckerObject(KeywordChecks.class).annotationDeclarationModifiersCheck(node);
        return !this.recursing;
    }

    @Override
    public boolean visitAnnotationMethodDeclaration(AnnotationMethodDeclaration node) {
        this.getCheckerObject(KeywordChecks.class).annotationMethodModifiersCheck(node);
        return !this.recursing;
    }

    @Override
    public boolean visitBreak(Break node) {
        this.getCheckerObject(UnreachableStatementsChecks.class).unreachablesAfterBreak(node);
        return !this.recursing;
    }

    @Override
    public boolean visitCase(Case node) {
        this.getCheckerObject(StatementChecks.class).checkCaseChildOfSwitch(node);
        return !this.recursing;
    }

    @Override
    public boolean visitCatch(Catch node) {
        this.getCheckerObject(StatementChecks.class).checkVarDefOfCatch(node);
        return !this.recursing;
    }

    @Override
    public boolean visitClassDeclaration(ClassDeclaration node) {
        this.getCheckerObject(KeywordChecks.class).classDeclarationModifiersCheck(node);
        return !this.recursing;
    }

    @Override
    public boolean visitConstructorDeclaration(ConstructorDeclaration node) {
        this.getCheckerObject(StructuralChecks.class).checkConstructorParamsAreSimple(node);
        return !this.recursing;
    }

    @Override
    public boolean visitContinue(Continue node) {
        this.getCheckerObject(UnreachableStatementsChecks.class).unreachablesAfterContinue(node);
        return !this.recursing;
    }

    @Override
    public boolean visitDefault(Default node) {
        this.getCheckerObject(StatementChecks.class).checkDefaultChildOfSwitch(node);
        return !this.recursing;
    }

    @Override
    public boolean visitDoWhile(DoWhile node) {
        this.getCheckerObject(StatementChecks.class).checkDeclarationsAsDirectChildDo(node);
        return !this.recursing;
    }

    @Override
    public boolean visitEmptyDeclaration(EmptyDeclaration node) {
        this.getCheckerObject(KeywordChecks.class).emptyDeclarationMustHaveNoModifiers(node);
        return !this.recursing;
    }

    @Override
    public boolean visitEnumDeclaration(EnumDeclaration node) {
        this.getCheckerObject(KeywordChecks.class).enumDeclarationModifiersCheck(node);
        return !this.recursing;
    }

    @Override
    public boolean visitFor(For node) {
        this.getCheckerObject(StatementChecks.class).checkDeclarationsAsDirectChildFor(node);
        return !this.recursing;
    }

    @Override
    public boolean visitForEach(ForEach node) {
        this.getCheckerObject(StatementChecks.class).checkDeclarationsAsDirectChildForEach(node);
        this.getCheckerObject(StatementChecks.class).checkVarDefOfForEach(node);
        return !this.recursing;
    }

    @Override
    public boolean visitIdentifier(Identifier node) {
        this.getCheckerObject(BasicChecks.class).checkNameOfIdentifier(node);
        return !this.recursing;
    }

    @Override
    public boolean visitIf(If node) {
        this.getCheckerObject(StatementChecks.class).checkDeclarationsAsDirectChildIf(node);
        return !this.recursing;
    }

    @Override
    public boolean visitInstanceInitializer(InstanceInitializer node) {
        this.getCheckerObject(StructuralChecks.class).initializersMustCompleteNormallyInstance(node);
        return !this.recursing;
    }

    @Override
    public boolean visitInterfaceDeclaration(InterfaceDeclaration node) {
        this.getCheckerObject(KeywordChecks.class).interfaceDeclarationModifiersCheck(node);
        return !this.recursing;
    }

    @Override
    public boolean visitMethodDeclaration(MethodDeclaration node) {
        this.getCheckerObject(KeywordChecks.class).methodModifiersCheck(node);
        this.getCheckerObject(StructuralChecks.class).checkAbstractMembersOnlyInAbstractTypes(node);
        this.getCheckerObject(StructuralChecks.class).checkMethodParamsAreSimple(node);
        return !this.recursing;
    }

    @Override
    public boolean visitModifiers(Modifiers node) {
        this.getCheckerObject(KeywordChecks.class).duplicateKeywordModifierCheck(node);
        return !this.recursing;
    }

    @Override
    public boolean visitReturn(Return node) {
        this.getCheckerObject(UnreachableStatementsChecks.class).unreachableAfterReturn(node);
        return !this.recursing;
    }

    @Override
    public boolean visitStaticInitializer(StaticInitializer node) {
        this.getCheckerObject(KeywordChecks.class).checkStaticInitializerInNonStaticType(node);
        this.getCheckerObject(StructuralChecks.class).initializersMustCompleteNormallyStatic(node);
        return !this.recursing;
    }

    @Override
    public boolean visitSuperConstructorInvocation(SuperConstructorInvocation node) {
        this.getCheckerObject(StructuralChecks.class).superConstructorInvocationMustBeFirst(node);
        return !this.recursing;
    }

    @Override
    public boolean visitSwitch(Switch node) {
        this.getCheckerObject(StatementChecks.class).checkSwitchStartsWithDefaultOrCase(node);
        return !this.recursing;
    }

    @Override
    public boolean visitTry(Try node) {
        this.getCheckerObject(StatementChecks.class).checkNotLoneTry(node);
        return !this.recursing;
    }

    @Override
    public boolean visitTypeReference(TypeReference node) {
        this.getCheckerObject(TypeChecks.class).checkNoPrimitivesInGenerics(node);
        this.getCheckerObject(TypeChecks.class).checkVoidNotLegalJustAboutEverywhere(node);
        return !this.recursing;
    }

    @Override
    public boolean visitVariableDeclaration(VariableDeclaration node) {
        this.getCheckerObject(KeywordChecks.class).fieldModifiersCheck(node);
        return !this.recursing;
    }

    @Override
    public boolean visitVariableDefinition(VariableDefinition node) {
        this.getCheckerObject(KeywordChecks.class).localVariableModifiersCheck(node);
        this.getCheckerObject(StructuralChecks.class).varDefOfZero(node);
        this.getCheckerObject(StructuralChecks.class).varargsOnlyLegalOnMethods(node);
        return !this.recursing;
    }

    @Override
    public boolean visitVariableDefinitionEntry(VariableDefinitionEntry node) {
        this.getCheckerObject(StructuralChecks.class).varargsAndExtendedDimsDontMix(node);
        return !this.recursing;
    }

    @Override
    public boolean visitWhile(While node) {
        this.getCheckerObject(StatementChecks.class).checkDeclarationsAsDirectChildWhile(node);
        return !this.recursing;
    }
}

