/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.syntaxChecks;

import lombok.ast.AlternateConstructorInvocation;
import lombok.ast.Block;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.InstanceInitializer;
import lombok.ast.Message;
import lombok.ast.MethodDeclaration;
import lombok.ast.Modifiers;
import lombok.ast.Node;
import lombok.ast.Return;
import lombok.ast.Statement;
import lombok.ast.StaticInitializer;
import lombok.ast.SuperConstructorInvocation;
import lombok.ast.Throw;
import lombok.ast.TypeDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.syntaxChecks.BasicChecks;
import lombok.ast.syntaxChecks.MessageKey;

public class StructuralChecks {
    public void checkAbstractMembersOnlyInAbstractTypes(MethodDeclaration md) {
        Modifiers modifiers = md.astModifiers();
        if (modifiers == null) {
            return;
        }
        if (!modifiers.isAbstract()) {
            return;
        }
        TypeDeclaration parent = md.upUpToTypeDeclaration();
        if (parent != null) {
            Modifiers modifiersOfParent = parent.astModifiers();
            if (modifiersOfParent != null && modifiersOfParent.isAbstract()) {
                return;
            }
            md.addMessage(Message.error(MessageKey.MODIFIERS_ABSTRACT_NOT_ALLOWED, "Abstract methods are only allowed in interfaces and abstract classes"));
        }
    }

    public void initializersMustCompleteNormallyStatic(StaticInitializer node) {
        this.initializersMustCompleteNormally(node.rawBody());
    }

    public void initializersMustCompleteNormallyInstance(InstanceInitializer node) {
        this.initializersMustCompleteNormally(node.rawBody());
    }

    private void initializersMustCompleteNormally(Node rawBlock) {
        if (!(rawBlock instanceof Block)) {
            return;
        }
        for (Node s : ((Block)rawBlock).rawContents()) {
            if (s instanceof Throw) {
                s.addMessage(Message.error(MessageKey.INITIALIZERS_INITIALIZER_MUST_COMPLETE_NORMALLY, "Initializers may not contain throws statements."));
            }
            if (!(s instanceof Return)) continue;
            s.addMessage(Message.error(MessageKey.INITIALIZERS_INITIALIZER_MUST_COMPLETE_NORMALLY, "Initializers may not contain return statements."));
        }
    }

    public void superConstructorInvocationMustBeFirst(SuperConstructorInvocation node) {
        this.constructorInvocationMustBeFirst(node, "super");
    }

    public void alternateConstructorInvocationMustBeFirst(AlternateConstructorInvocation node) {
        this.constructorInvocationMustBeFirst(node, "this");
    }

    private void constructorInvocationMustBeFirst(Statement node, String desc) {
        if (node.getParent() == null) {
            return;
        }
        Block b = node.upToBlock();
        if (b == null || b.upToConstructorDeclaration() == null || b.astContents().first() != node) {
            node.addMessage(Message.error(MessageKey.CONSTRUCTOR_INVOCATION_NOT_LEGAL_HERE, "Calling " + desc + " must be the first statement in a constructor."));
            return;
        }
    }

    public void varDefOfZero(VariableDefinition node) {
        if (node.astVariables().isEmpty()) {
            node.addMessage(Message.error(MessageKey.VARIABLEDEFINITION_EMPTY, "Empty variable declaration."));
        }
    }

    public void varargsOnlyLegalOnMethods(VariableDefinition node) {
        if (!node.astVarargs()) {
            return;
        }
        if (node.getParent() == null) {
            return;
        }
        MethodDeclaration md = node.upIfParameterToMethodDeclaration();
        ConstructorDeclaration cd = node.upIfParameterToConstructorDeclaration();
        VariableDefinition last = md != null ? md.astParameters().last() : (cd != null ? cd.astParameters().last() : null);
        if (node != last) {
            node.addMessage(Message.error(MessageKey.VARIABLEDEFINITION_VARARGS_NOT_LEGAL_HERE, "Varargs are only legal on the last parameter of a constructor or method."));
        }
    }

    public void varargsAndExtendedDimsDontMix(VariableDefinitionEntry node) {
        VariableDefinition vd = node.upToVariableDefinition();
        if (vd == null) {
            return;
        }
        if (node.astArrayDimensions() > 0 && vd.astVarargs()) {
            node.addMessage(Message.error(MessageKey.VARIABLEDEFINITIONENTRY_EXTENDED_DIMENSIONS_NOT_LEGAL, "Extended dimensions are not legal on a varargs declaration."));
        }
    }

    public void checkMethodParamsAreSimple(MethodDeclaration md) {
        for (Node param : md.rawParameters()) {
            BasicChecks.checkVarDefIsSimple(param, param, "method parameters", "parameter");
        }
    }

    public void checkConstructorParamsAreSimple(ConstructorDeclaration cd) {
        for (Node param : cd.rawParameters()) {
            BasicChecks.checkVarDefIsSimple(param, param, "constructor parameters", "parameter");
        }
    }
}

