/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.transform;

import lombok.ast.libs.org.parboiled.asm.Opcodes;
import lombok.ast.libs.org.parboiled.asm.Type;
import lombok.ast.libs.org.parboiled.asm.tree.AbstractInsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.InsnList;
import lombok.ast.libs.org.parboiled.asm.tree.MethodInsnNode;
import lombok.ast.libs.org.parboiled.google.base.Preconditions;
import lombok.ast.libs.org.parboiled.transform.ParserClassNode;
import lombok.ast.libs.org.parboiled.transform.RuleMethod;
import lombok.ast.libs.org.parboiled.transform.RuleMethodProcessor;
import org.jetbrains.annotations.NotNull;

class SuperCallRewriter
implements Opcodes,
RuleMethodProcessor {
    SuperCallRewriter() {
    }

    public boolean appliesTo(@NotNull ParserClassNode classNode, @NotNull RuleMethod method) {
        if (classNode == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.SuperCallRewriter.appliesTo(...) corresponds to @NotNull parameter and must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.transform.SuperCallRewriter.appliesTo(...) corresponds to @NotNull parameter and must not be null");
        }
        return method.containsPotentialSuperCalls();
    }

    public void process(@NotNull ParserClassNode classNode, @NotNull RuleMethod method) throws Exception {
        if (classNode == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.SuperCallRewriter.process(...) corresponds to @NotNull parameter and must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.transform.SuperCallRewriter.process(...) corresponds to @NotNull parameter and must not be null");
        }
        InsnList instructions = method.instructions;
        AbstractInsnNode insn = instructions.getFirst();
        while (insn.getOpcode() != 176) {
            if (insn.getOpcode() == 183) {
                this.process(classNode, method, (MethodInsnNode)insn);
            }
            insn = insn.getNext();
        }
    }

    private void process(ParserClassNode classNode, RuleMethod method, MethodInsnNode insn) {
        if ("<init>".equals(insn.name)) {
            return;
        }
        String superMethodName = this.getSuperMethodName(method, insn);
        RuleMethod superMethod = classNode.getRuleMethods().get(superMethodName.concat(insn.desc));
        if (superMethod == null) {
            return;
        }
        if (!superMethod.isBodyRewritten()) {
            return;
        }
        superMethod.dontSkipGeneration();
        insn.setOpcode(182);
        insn.name = superMethodName;
        insn.owner = classNode.name;
        method.setBodyRewritten();
    }

    private String getSuperMethodName(RuleMethod method, MethodInsnNode insn) {
        Class<?> clazz = method.getOwnerClass();
        String superMethodName = method.name;
        do {
            Preconditions.checkState((clazz = clazz.getSuperclass()) != null);
            superMethodName = '$' + superMethodName;
        } while (!Type.getInternalName(clazz).equals(insn.owner));
        return superMethodName;
    }
}

