/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.matchers;

import lombok.ast.libs.org.parboiled.MatcherContext;
import lombok.ast.libs.org.parboiled.google.base.Preconditions;
import lombok.ast.libs.org.parboiled.matchers.AbstractMatcher;
import lombok.ast.libs.org.parboiled.matchers.MatcherVisitor;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharRangeMatcher<V>
extends AbstractMatcher<V> {
    public final char cLow;
    public final char cHigh;

    public CharRangeMatcher(char cLow, char cHigh) {
        Preconditions.checkArgument(cLow < cHigh);
        this.cLow = cLow;
        this.cHigh = cHigh;
    }

    @Override
    public boolean match(@NotNull MatcherContext<V> context) {
        if (context == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.matchers.CharRangeMatcher.match(...) corresponds to @NotNull parameter and must not be null");
        }
        char c = context.getCurrentChar();
        if (c < this.cLow || c > this.cHigh) {
            return false;
        }
        context.advanceIndex();
        context.createNode();
        return true;
    }

    @Override
    public <R> R accept(@NotNull MatcherVisitor<V, R> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.matchers.CharRangeMatcher.accept(...) corresponds to @NotNull parameter and must not be null");
        }
        return visitor.visit(this);
    }
}

