/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.errors;

import java.util.List;
import lombok.ast.libs.org.parboiled.common.Formatter;
import lombok.ast.libs.org.parboiled.common.StringUtils;
import lombok.ast.libs.org.parboiled.errors.DefaultInvalidInputErrorFormatter;
import lombok.ast.libs.org.parboiled.errors.InvalidInputError;
import lombok.ast.libs.org.parboiled.errors.ParseError;
import lombok.ast.libs.org.parboiled.matchers.AbstractMatcher;
import lombok.ast.libs.org.parboiled.matchers.ActionMatcher;
import lombok.ast.libs.org.parboiled.matchers.EmptyMatcher;
import lombok.ast.libs.org.parboiled.matchers.FirstOfMatcher;
import lombok.ast.libs.org.parboiled.matchers.Matcher;
import lombok.ast.libs.org.parboiled.matchers.OneOrMoreMatcher;
import lombok.ast.libs.org.parboiled.matchers.OptionalMatcher;
import lombok.ast.libs.org.parboiled.matchers.SequenceMatcher;
import lombok.ast.libs.org.parboiled.matchers.ZeroOrMoreMatcher;
import lombok.ast.libs.org.parboiled.support.DefaultMatcherVisitor;
import lombok.ast.libs.org.parboiled.support.InputBuffer;
import lombok.ast.libs.org.parboiled.support.MatcherPath;
import lombok.ast.libs.org.parboiled.support.ParsingResult;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ErrorUtils {
    private ErrorUtils() {
    }

    public static <V> Matcher<V> findProperLabelMatcher(@NotNull MatcherPath<V> failedMatcherPath, MatcherPath<V> lastMatchPath) {
        if (failedMatcherPath == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.errors.ErrorUtils.findProperLabelMatcher(...) corresponds to @NotNull parameter and must not be null");
        }
        int commonPrefixLength = failedMatcherPath.getCommonPrefixLength(lastMatchPath);
        if (lastMatchPath != null && commonPrefixLength == lastMatchPath.length()) {
            return failedMatcherPath.getHead();
        }
        DefaultMatcherVisitor hasProperLabelVisitor = new DefaultMatcherVisitor<V, Boolean>(){

            @Override
            public Boolean visit(ActionMatcher<V> matcher) {
                return false;
            }

            @Override
            public Boolean visit(EmptyMatcher<V> matcher) {
                return false;
            }

            @Override
            public Boolean visit(FirstOfMatcher<V> matcher) {
                String label = matcher.getLabel();
                return !"FirstOf".equals(label);
            }

            @Override
            public Boolean visit(OneOrMoreMatcher<V> matcher) {
                return !"OneOrMore".equals(matcher.getLabel());
            }

            @Override
            public Boolean visit(OptionalMatcher<V> matcher) {
                return !"Optional".equals(matcher.getLabel());
            }

            @Override
            public Boolean visit(SequenceMatcher<V> matcher) {
                return !"Sequence".equals(matcher.getLabel());
            }

            @Override
            public Boolean visit(ZeroOrMoreMatcher<V> matcher) {
                return !"ZeroOrMore".equals(matcher.getLabel());
            }

            @Override
            public Boolean defaultValue(AbstractMatcher<V> matcher) {
                return true;
            }
        };
        for (int i = commonPrefixLength; i < failedMatcherPath.length(); ++i) {
            Matcher<V> matcher = failedMatcherPath.get(i);
            if (!((Boolean)matcher.accept(hasProperLabelVisitor)).booleanValue()) continue;
            return matcher;
        }
        return null;
    }

    public static <V> String printParseError(@NotNull ParseError error, @NotNull InputBuffer inputBuffer) {
        if (error == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.errors.ErrorUtils.printParseError(...) corresponds to @NotNull parameter and must not be null");
        }
        if (inputBuffer == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.errors.ErrorUtils.printParseError(...) corresponds to @NotNull parameter and must not be null");
        }
        return ErrorUtils.printParseError(error, inputBuffer, new DefaultInvalidInputErrorFormatter());
    }

    public static <V> String printParseError(@NotNull ParseError error, @NotNull InputBuffer inputBuffer, @NotNull Formatter<InvalidInputError<V>> formatter) {
        int i;
        if (error == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.errors.ErrorUtils.printParseError(...) corresponds to @NotNull parameter and must not be null");
        }
        if (inputBuffer == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.errors.ErrorUtils.printParseError(...) corresponds to @NotNull parameter and must not be null");
        }
        if (formatter == null) {
            throw new IllegalArgumentException("3rd argument of method org.parboiled.errors.ErrorUtils.printParseError(...) corresponds to @NotNull parameter and must not be null");
        }
        int start = error.getStartIndex();
        String message = error.getErrorMessage() != null ? error.getErrorMessage() : (error instanceof InvalidInputError ? formatter.format((InvalidInputError)error) : error.getClass().getSimpleName());
        InputBuffer.Position pos = inputBuffer.getPosition(start);
        StringBuilder sb = new StringBuilder(message);
        sb.append(String.format(" (line %s, pos %s):", pos.line, pos.column));
        sb.append('\n');
        String line = inputBuffer.extractLine(pos.line);
        sb.append(line);
        sb.append('\n');
        int charCount = Math.min(error.getEndIndex() - error.getStartIndex(), StringUtils.length(line) - pos.column + 2);
        for (i = 0; i < pos.column - 1; ++i) {
            sb.append(' ');
        }
        for (i = 0; i < charCount; ++i) {
            sb.append('^');
        }
        sb.append("\n");
        return sb.toString();
    }

    public static String printParseErrors(@NotNull ParsingResult<?> parsingResult) {
        if (parsingResult == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.errors.ErrorUtils.printParseErrors(...) corresponds to @NotNull parameter and must not be null");
        }
        return ErrorUtils.printParseErrors(parsingResult.parseErrors, parsingResult.inputBuffer);
    }

    public static String printParseErrors(@NotNull List<ParseError> errors, @NotNull InputBuffer inputBuffer) {
        if (errors == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.errors.ErrorUtils.printParseErrors(...) corresponds to @NotNull parameter and must not be null");
        }
        if (inputBuffer == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.errors.ErrorUtils.printParseErrors(...) corresponds to @NotNull parameter and must not be null");
        }
        StringBuilder sb = new StringBuilder();
        for (ParseError error : errors) {
            if (sb.length() > 0) {
                sb.append("---\n");
            }
            sb.append(ErrorUtils.printParseError(error, inputBuffer));
        }
        return sb.toString();
    }
}

