/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Expression;
import lombok.ast.ExpressionMixin;
import lombok.ast.InstanceOfTemplate;
import lombok.ast.Node;
import lombok.ast.Position;
import lombok.ast.TypeReference;

public class InstanceOf
extends AbstractNode
implements Expression {
    private List<Position> parensPositions = new ArrayList<Position>();
    private AbstractNode objectReference = null;
    private AbstractNode typeReference = null;

    @Override
    public List<Position> astParensPositions() {
        return this.parensPositions;
    }

    public Expression astObjectReference() {
        if (!(this.objectReference instanceof Expression)) {
            return null;
        }
        return (Expression)((Object)this.objectReference);
    }

    public InstanceOf astObjectReference(Expression objectReference) {
        if (objectReference == null) {
            throw new NullPointerException("objectReference is mandatory");
        }
        return this.rawObjectReference(objectReference);
    }

    public Node rawObjectReference() {
        return this.objectReference;
    }

    public InstanceOf rawObjectReference(Node objectReference) {
        if (objectReference == this.objectReference) {
            return this;
        }
        if (objectReference != null) {
            this.adopt((AbstractNode)objectReference);
        }
        if (this.objectReference != null) {
            this.disown(this.objectReference);
        }
        this.objectReference = (AbstractNode)objectReference;
        return this;
    }

    public TypeReference astTypeReference() {
        if (!(this.typeReference instanceof TypeReference)) {
            return null;
        }
        return (TypeReference)this.typeReference;
    }

    public InstanceOf astTypeReference(TypeReference typeReference) {
        if (typeReference == null) {
            throw new NullPointerException("typeReference is mandatory");
        }
        return this.rawTypeReference(typeReference);
    }

    public Node rawTypeReference() {
        return this.typeReference;
    }

    public InstanceOf rawTypeReference(Node typeReference) {
        if (typeReference == this.typeReference) {
            return this;
        }
        if (typeReference != null) {
            this.adopt((AbstractNode)typeReference);
        }
        if (this.typeReference != null) {
            this.disown(this.typeReference);
        }
        this.typeReference = (AbstractNode)typeReference;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.objectReference != null) {
            result.add(this.objectReference);
        }
        if (this.typeReference != null) {
            result.add(this.typeReference);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.objectReference == original) {
            this.rawObjectReference(replacement);
            return true;
        }
        if (this.typeReference == original) {
            this.rawTypeReference(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.objectReference == child) {
            this.disown((AbstractNode)child);
            this.objectReference = null;
            return true;
        }
        if (this.typeReference == child) {
            this.disown((AbstractNode)child);
            this.typeReference = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitInstanceOf(this)) {
            return;
        }
        if (this.objectReference != null) {
            this.objectReference.accept(visitor);
        }
        if (this.typeReference != null) {
            this.typeReference.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public InstanceOf copy() {
        InstanceOf result = new InstanceOf();
        result.parensPositions = new ArrayList<Position>(this.parensPositions);
        if (this.objectReference != null) {
            result.rawObjectReference(this.objectReference.copy());
        }
        if (this.typeReference != null) {
            result.rawTypeReference(this.typeReference.copy());
        }
        return result;
    }

    @Override
    public boolean needsParentheses() {
        return InstanceOfTemplate.needsParentheses(this);
    }

    @Override
    public int getParens() {
        return ExpressionMixin.getParens(this);
    }

    @Override
    public int getIntendedParens() {
        return ExpressionMixin.getIntendedParens(this);
    }

    @Override
    public boolean isStatementExpression() {
        return ExpressionMixin.isStatementExpression(this);
    }
}

