/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Block;
import lombok.ast.Expression;
import lombok.ast.Node;
import lombok.ast.Statement;

public class ExpressionStatement
extends AbstractNode
implements Statement {
    private AbstractNode expression = null;

    @Override
    public Block upToBlock() {
        if (!(this.getParent() instanceof Block)) {
            return null;
        }
        Block out = (Block)this.getParent();
        if (!out.rawContents().contains(this)) {
            return null;
        }
        return out;
    }

    public Expression astExpression() {
        if (!(this.expression instanceof Expression)) {
            return null;
        }
        return (Expression)((Object)this.expression);
    }

    public ExpressionStatement astExpression(Expression expression) {
        if (expression == null) {
            throw new NullPointerException("expression is mandatory");
        }
        return this.rawExpression(expression);
    }

    public Node rawExpression() {
        return this.expression;
    }

    public ExpressionStatement rawExpression(Node expression) {
        if (expression == this.expression) {
            return this;
        }
        if (expression != null) {
            this.adopt((AbstractNode)expression);
        }
        if (this.expression != null) {
            this.disown(this.expression);
        }
        this.expression = (AbstractNode)expression;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.expression != null) {
            result.add(this.expression);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.expression == original) {
            this.rawExpression(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.expression == child) {
            this.disown((AbstractNode)child);
            this.expression = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitExpressionStatement(this)) {
            return;
        }
        if (this.expression != null) {
            this.expression.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public ExpressionStatement copy() {
        ExpressionStatement result = new ExpressionStatement();
        if (this.expression != null) {
            result.rawExpression(this.expression.copy());
        }
        return result;
    }
}

