/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simplesystemsmanagement.model.AlarmConfiguration;
import com.amazonaws.services.simplesystemsmanagement.model.AlarmStateInformation;
import com.amazonaws.services.simplesystemsmanagement.model.AutomationExecutionStatus;
import com.amazonaws.services.simplesystemsmanagement.model.AutomationSubtype;
import com.amazonaws.services.simplesystemsmanagement.model.ExecutionMode;
import com.amazonaws.services.simplesystemsmanagement.model.ProgressCounters;
import com.amazonaws.services.simplesystemsmanagement.model.ResolvedTargets;
import com.amazonaws.services.simplesystemsmanagement.model.Runbook;
import com.amazonaws.services.simplesystemsmanagement.model.StepExecution;
import com.amazonaws.services.simplesystemsmanagement.model.Target;
import com.amazonaws.services.simplesystemsmanagement.model.TargetLocation;
import com.amazonaws.services.simplesystemsmanagement.model.transform.AutomationExecutionMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AutomationExecution
implements Serializable,
Cloneable,
StructuredPojo {
    private String automationExecutionId;
    private String documentName;
    private String documentVersion;
    private Date executionStartTime;
    private Date executionEndTime;
    private String automationExecutionStatus;
    private SdkInternalList<StepExecution> stepExecutions;
    private Boolean stepExecutionsTruncated;
    private Map<String, List<String>> parameters;
    private Map<String, List<String>> outputs;
    private String failureMessage;
    private String mode;
    private String parentAutomationExecutionId;
    private String executedBy;
    private String currentStepName;
    private String currentAction;
    private String targetParameterName;
    private SdkInternalList<Target> targets;
    private SdkInternalList<Map<String, List<String>>> targetMaps;
    private ResolvedTargets resolvedTargets;
    private String maxConcurrency;
    private String maxErrors;
    private String target;
    private SdkInternalList<TargetLocation> targetLocations;
    private ProgressCounters progressCounters;
    private AlarmConfiguration alarmConfiguration;
    private SdkInternalList<AlarmStateInformation> triggeredAlarms;
    private String automationSubtype;
    private Date scheduledTime;
    private SdkInternalList<Runbook> runbooks;
    private String opsItemId;
    private String associationId;
    private String changeRequestName;
    private Map<String, List<String>> variables;

    public void setAutomationExecutionId(String automationExecutionId) {
        this.automationExecutionId = automationExecutionId;
    }

    public String getAutomationExecutionId() {
        return this.automationExecutionId;
    }

    public AutomationExecution withAutomationExecutionId(String automationExecutionId) {
        this.setAutomationExecutionId(automationExecutionId);
        return this;
    }

    public void setDocumentName(String documentName) {
        this.documentName = documentName;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public AutomationExecution withDocumentName(String documentName) {
        this.setDocumentName(documentName);
        return this;
    }

    public void setDocumentVersion(String documentVersion) {
        this.documentVersion = documentVersion;
    }

    public String getDocumentVersion() {
        return this.documentVersion;
    }

    public AutomationExecution withDocumentVersion(String documentVersion) {
        this.setDocumentVersion(documentVersion);
        return this;
    }

    public void setExecutionStartTime(Date executionStartTime) {
        this.executionStartTime = executionStartTime;
    }

    public Date getExecutionStartTime() {
        return this.executionStartTime;
    }

    public AutomationExecution withExecutionStartTime(Date executionStartTime) {
        this.setExecutionStartTime(executionStartTime);
        return this;
    }

    public void setExecutionEndTime(Date executionEndTime) {
        this.executionEndTime = executionEndTime;
    }

    public Date getExecutionEndTime() {
        return this.executionEndTime;
    }

    public AutomationExecution withExecutionEndTime(Date executionEndTime) {
        this.setExecutionEndTime(executionEndTime);
        return this;
    }

    public void setAutomationExecutionStatus(String automationExecutionStatus) {
        this.automationExecutionStatus = automationExecutionStatus;
    }

    public String getAutomationExecutionStatus() {
        return this.automationExecutionStatus;
    }

    public AutomationExecution withAutomationExecutionStatus(String automationExecutionStatus) {
        this.setAutomationExecutionStatus(automationExecutionStatus);
        return this;
    }

    public void setAutomationExecutionStatus(AutomationExecutionStatus automationExecutionStatus) {
        this.withAutomationExecutionStatus(automationExecutionStatus);
    }

    public AutomationExecution withAutomationExecutionStatus(AutomationExecutionStatus automationExecutionStatus) {
        this.automationExecutionStatus = automationExecutionStatus.toString();
        return this;
    }

    public List<StepExecution> getStepExecutions() {
        if (this.stepExecutions == null) {
            this.stepExecutions = new SdkInternalList();
        }
        return this.stepExecutions;
    }

    public void setStepExecutions(Collection<StepExecution> stepExecutions) {
        if (stepExecutions == null) {
            this.stepExecutions = null;
            return;
        }
        this.stepExecutions = new SdkInternalList(stepExecutions);
    }

    public AutomationExecution withStepExecutions(StepExecution ... stepExecutions) {
        if (this.stepExecutions == null) {
            this.setStepExecutions((Collection<StepExecution>)new SdkInternalList(stepExecutions.length));
        }
        for (StepExecution ele : stepExecutions) {
            this.stepExecutions.add((Object)ele);
        }
        return this;
    }

    public AutomationExecution withStepExecutions(Collection<StepExecution> stepExecutions) {
        this.setStepExecutions(stepExecutions);
        return this;
    }

    public void setStepExecutionsTruncated(Boolean stepExecutionsTruncated) {
        this.stepExecutionsTruncated = stepExecutionsTruncated;
    }

    public Boolean getStepExecutionsTruncated() {
        return this.stepExecutionsTruncated;
    }

    public AutomationExecution withStepExecutionsTruncated(Boolean stepExecutionsTruncated) {
        this.setStepExecutionsTruncated(stepExecutionsTruncated);
        return this;
    }

    public Boolean isStepExecutionsTruncated() {
        return this.stepExecutionsTruncated;
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, List<String>> parameters) {
        this.parameters = parameters;
    }

    public AutomationExecution withParameters(Map<String, List<String>> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public AutomationExecution addParametersEntry(String key, List<String> value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, List<String>>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public AutomationExecution clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public Map<String, List<String>> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Map<String, List<String>> outputs) {
        this.outputs = outputs;
    }

    public AutomationExecution withOutputs(Map<String, List<String>> outputs) {
        this.setOutputs(outputs);
        return this;
    }

    public AutomationExecution addOutputsEntry(String key, List<String> value) {
        if (null == this.outputs) {
            this.outputs = new HashMap<String, List<String>>();
        }
        if (this.outputs.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.outputs.put(key, value);
        return this;
    }

    public AutomationExecution clearOutputsEntries() {
        this.outputs = null;
        return this;
    }

    public void setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public AutomationExecution withFailureMessage(String failureMessage) {
        this.setFailureMessage(failureMessage);
        return this;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getMode() {
        return this.mode;
    }

    public AutomationExecution withMode(String mode) {
        this.setMode(mode);
        return this;
    }

    public void setMode(ExecutionMode mode) {
        this.withMode(mode);
    }

    public AutomationExecution withMode(ExecutionMode mode) {
        this.mode = mode.toString();
        return this;
    }

    public void setParentAutomationExecutionId(String parentAutomationExecutionId) {
        this.parentAutomationExecutionId = parentAutomationExecutionId;
    }

    public String getParentAutomationExecutionId() {
        return this.parentAutomationExecutionId;
    }

    public AutomationExecution withParentAutomationExecutionId(String parentAutomationExecutionId) {
        this.setParentAutomationExecutionId(parentAutomationExecutionId);
        return this;
    }

    public void setExecutedBy(String executedBy) {
        this.executedBy = executedBy;
    }

    public String getExecutedBy() {
        return this.executedBy;
    }

    public AutomationExecution withExecutedBy(String executedBy) {
        this.setExecutedBy(executedBy);
        return this;
    }

    public void setCurrentStepName(String currentStepName) {
        this.currentStepName = currentStepName;
    }

    public String getCurrentStepName() {
        return this.currentStepName;
    }

    public AutomationExecution withCurrentStepName(String currentStepName) {
        this.setCurrentStepName(currentStepName);
        return this;
    }

    public void setCurrentAction(String currentAction) {
        this.currentAction = currentAction;
    }

    public String getCurrentAction() {
        return this.currentAction;
    }

    public AutomationExecution withCurrentAction(String currentAction) {
        this.setCurrentAction(currentAction);
        return this;
    }

    public void setTargetParameterName(String targetParameterName) {
        this.targetParameterName = targetParameterName;
    }

    public String getTargetParameterName() {
        return this.targetParameterName;
    }

    public AutomationExecution withTargetParameterName(String targetParameterName) {
        this.setTargetParameterName(targetParameterName);
        return this;
    }

    public List<Target> getTargets() {
        if (this.targets == null) {
            this.targets = new SdkInternalList();
        }
        return this.targets;
    }

    public void setTargets(Collection<Target> targets) {
        if (targets == null) {
            this.targets = null;
            return;
        }
        this.targets = new SdkInternalList(targets);
    }

    public AutomationExecution withTargets(Target ... targets) {
        if (this.targets == null) {
            this.setTargets((Collection<Target>)new SdkInternalList(targets.length));
        }
        for (Target ele : targets) {
            this.targets.add((Object)ele);
        }
        return this;
    }

    public AutomationExecution withTargets(Collection<Target> targets) {
        this.setTargets(targets);
        return this;
    }

    public List<Map<String, List<String>>> getTargetMaps() {
        if (this.targetMaps == null) {
            this.targetMaps = new SdkInternalList();
        }
        return this.targetMaps;
    }

    public void setTargetMaps(Collection<Map<String, List<String>>> targetMaps) {
        if (targetMaps == null) {
            this.targetMaps = null;
            return;
        }
        this.targetMaps = new SdkInternalList(targetMaps);
    }

    public AutomationExecution withTargetMaps(Map<String, List<String>> ... targetMaps) {
        if (this.targetMaps == null) {
            this.setTargetMaps((Collection<Map<String, List<String>>>)new SdkInternalList(targetMaps.length));
        }
        for (Map<String, List<String>> ele : targetMaps) {
            this.targetMaps.add(ele);
        }
        return this;
    }

    public AutomationExecution withTargetMaps(Collection<Map<String, List<String>>> targetMaps) {
        this.setTargetMaps(targetMaps);
        return this;
    }

    public void setResolvedTargets(ResolvedTargets resolvedTargets) {
        this.resolvedTargets = resolvedTargets;
    }

    public ResolvedTargets getResolvedTargets() {
        return this.resolvedTargets;
    }

    public AutomationExecution withResolvedTargets(ResolvedTargets resolvedTargets) {
        this.setResolvedTargets(resolvedTargets);
        return this;
    }

    public void setMaxConcurrency(String maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
    }

    public String getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public AutomationExecution withMaxConcurrency(String maxConcurrency) {
        this.setMaxConcurrency(maxConcurrency);
        return this;
    }

    public void setMaxErrors(String maxErrors) {
        this.maxErrors = maxErrors;
    }

    public String getMaxErrors() {
        return this.maxErrors;
    }

    public AutomationExecution withMaxErrors(String maxErrors) {
        this.setMaxErrors(maxErrors);
        return this;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getTarget() {
        return this.target;
    }

    public AutomationExecution withTarget(String target) {
        this.setTarget(target);
        return this;
    }

    public List<TargetLocation> getTargetLocations() {
        if (this.targetLocations == null) {
            this.targetLocations = new SdkInternalList();
        }
        return this.targetLocations;
    }

    public void setTargetLocations(Collection<TargetLocation> targetLocations) {
        if (targetLocations == null) {
            this.targetLocations = null;
            return;
        }
        this.targetLocations = new SdkInternalList(targetLocations);
    }

    public AutomationExecution withTargetLocations(TargetLocation ... targetLocations) {
        if (this.targetLocations == null) {
            this.setTargetLocations((Collection<TargetLocation>)new SdkInternalList(targetLocations.length));
        }
        for (TargetLocation ele : targetLocations) {
            this.targetLocations.add((Object)ele);
        }
        return this;
    }

    public AutomationExecution withTargetLocations(Collection<TargetLocation> targetLocations) {
        this.setTargetLocations(targetLocations);
        return this;
    }

    public void setProgressCounters(ProgressCounters progressCounters) {
        this.progressCounters = progressCounters;
    }

    public ProgressCounters getProgressCounters() {
        return this.progressCounters;
    }

    public AutomationExecution withProgressCounters(ProgressCounters progressCounters) {
        this.setProgressCounters(progressCounters);
        return this;
    }

    public void setAlarmConfiguration(AlarmConfiguration alarmConfiguration) {
        this.alarmConfiguration = alarmConfiguration;
    }

    public AlarmConfiguration getAlarmConfiguration() {
        return this.alarmConfiguration;
    }

    public AutomationExecution withAlarmConfiguration(AlarmConfiguration alarmConfiguration) {
        this.setAlarmConfiguration(alarmConfiguration);
        return this;
    }

    public List<AlarmStateInformation> getTriggeredAlarms() {
        if (this.triggeredAlarms == null) {
            this.triggeredAlarms = new SdkInternalList();
        }
        return this.triggeredAlarms;
    }

    public void setTriggeredAlarms(Collection<AlarmStateInformation> triggeredAlarms) {
        if (triggeredAlarms == null) {
            this.triggeredAlarms = null;
            return;
        }
        this.triggeredAlarms = new SdkInternalList(triggeredAlarms);
    }

    public AutomationExecution withTriggeredAlarms(AlarmStateInformation ... triggeredAlarms) {
        if (this.triggeredAlarms == null) {
            this.setTriggeredAlarms((Collection<AlarmStateInformation>)new SdkInternalList(triggeredAlarms.length));
        }
        for (AlarmStateInformation ele : triggeredAlarms) {
            this.triggeredAlarms.add((Object)ele);
        }
        return this;
    }

    public AutomationExecution withTriggeredAlarms(Collection<AlarmStateInformation> triggeredAlarms) {
        this.setTriggeredAlarms(triggeredAlarms);
        return this;
    }

    public void setAutomationSubtype(String automationSubtype) {
        this.automationSubtype = automationSubtype;
    }

    public String getAutomationSubtype() {
        return this.automationSubtype;
    }

    public AutomationExecution withAutomationSubtype(String automationSubtype) {
        this.setAutomationSubtype(automationSubtype);
        return this;
    }

    public void setAutomationSubtype(AutomationSubtype automationSubtype) {
        this.withAutomationSubtype(automationSubtype);
    }

    public AutomationExecution withAutomationSubtype(AutomationSubtype automationSubtype) {
        this.automationSubtype = automationSubtype.toString();
        return this;
    }

    public void setScheduledTime(Date scheduledTime) {
        this.scheduledTime = scheduledTime;
    }

    public Date getScheduledTime() {
        return this.scheduledTime;
    }

    public AutomationExecution withScheduledTime(Date scheduledTime) {
        this.setScheduledTime(scheduledTime);
        return this;
    }

    public List<Runbook> getRunbooks() {
        if (this.runbooks == null) {
            this.runbooks = new SdkInternalList();
        }
        return this.runbooks;
    }

    public void setRunbooks(Collection<Runbook> runbooks) {
        if (runbooks == null) {
            this.runbooks = null;
            return;
        }
        this.runbooks = new SdkInternalList(runbooks);
    }

    public AutomationExecution withRunbooks(Runbook ... runbooks) {
        if (this.runbooks == null) {
            this.setRunbooks((Collection<Runbook>)new SdkInternalList(runbooks.length));
        }
        for (Runbook ele : runbooks) {
            this.runbooks.add((Object)ele);
        }
        return this;
    }

    public AutomationExecution withRunbooks(Collection<Runbook> runbooks) {
        this.setRunbooks(runbooks);
        return this;
    }

    public void setOpsItemId(String opsItemId) {
        this.opsItemId = opsItemId;
    }

    public String getOpsItemId() {
        return this.opsItemId;
    }

    public AutomationExecution withOpsItemId(String opsItemId) {
        this.setOpsItemId(opsItemId);
        return this;
    }

    public void setAssociationId(String associationId) {
        this.associationId = associationId;
    }

    public String getAssociationId() {
        return this.associationId;
    }

    public AutomationExecution withAssociationId(String associationId) {
        this.setAssociationId(associationId);
        return this;
    }

    public void setChangeRequestName(String changeRequestName) {
        this.changeRequestName = changeRequestName;
    }

    public String getChangeRequestName() {
        return this.changeRequestName;
    }

    public AutomationExecution withChangeRequestName(String changeRequestName) {
        this.setChangeRequestName(changeRequestName);
        return this;
    }

    public Map<String, List<String>> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, List<String>> variables) {
        this.variables = variables;
    }

    public AutomationExecution withVariables(Map<String, List<String>> variables) {
        this.setVariables(variables);
        return this;
    }

    public AutomationExecution addVariablesEntry(String key, List<String> value) {
        if (null == this.variables) {
            this.variables = new HashMap<String, List<String>>();
        }
        if (this.variables.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.variables.put(key, value);
        return this;
    }

    public AutomationExecution clearVariablesEntries() {
        this.variables = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAutomationExecutionId() != null) {
            sb.append("AutomationExecutionId: ").append(this.getAutomationExecutionId()).append(",");
        }
        if (this.getDocumentName() != null) {
            sb.append("DocumentName: ").append(this.getDocumentName()).append(",");
        }
        if (this.getDocumentVersion() != null) {
            sb.append("DocumentVersion: ").append(this.getDocumentVersion()).append(",");
        }
        if (this.getExecutionStartTime() != null) {
            sb.append("ExecutionStartTime: ").append(this.getExecutionStartTime()).append(",");
        }
        if (this.getExecutionEndTime() != null) {
            sb.append("ExecutionEndTime: ").append(this.getExecutionEndTime()).append(",");
        }
        if (this.getAutomationExecutionStatus() != null) {
            sb.append("AutomationExecutionStatus: ").append(this.getAutomationExecutionStatus()).append(",");
        }
        if (this.getStepExecutions() != null) {
            sb.append("StepExecutions: ").append(this.getStepExecutions()).append(",");
        }
        if (this.getStepExecutionsTruncated() != null) {
            sb.append("StepExecutionsTruncated: ").append(this.getStepExecutionsTruncated()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getOutputs() != null) {
            sb.append("Outputs: ").append(this.getOutputs()).append(",");
        }
        if (this.getFailureMessage() != null) {
            sb.append("FailureMessage: ").append(this.getFailureMessage()).append(",");
        }
        if (this.getMode() != null) {
            sb.append("Mode: ").append(this.getMode()).append(",");
        }
        if (this.getParentAutomationExecutionId() != null) {
            sb.append("ParentAutomationExecutionId: ").append(this.getParentAutomationExecutionId()).append(",");
        }
        if (this.getExecutedBy() != null) {
            sb.append("ExecutedBy: ").append(this.getExecutedBy()).append(",");
        }
        if (this.getCurrentStepName() != null) {
            sb.append("CurrentStepName: ").append(this.getCurrentStepName()).append(",");
        }
        if (this.getCurrentAction() != null) {
            sb.append("CurrentAction: ").append(this.getCurrentAction()).append(",");
        }
        if (this.getTargetParameterName() != null) {
            sb.append("TargetParameterName: ").append(this.getTargetParameterName()).append(",");
        }
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets()).append(",");
        }
        if (this.getTargetMaps() != null) {
            sb.append("TargetMaps: ").append(this.getTargetMaps()).append(",");
        }
        if (this.getResolvedTargets() != null) {
            sb.append("ResolvedTargets: ").append(this.getResolvedTargets()).append(",");
        }
        if (this.getMaxConcurrency() != null) {
            sb.append("MaxConcurrency: ").append(this.getMaxConcurrency()).append(",");
        }
        if (this.getMaxErrors() != null) {
            sb.append("MaxErrors: ").append(this.getMaxErrors()).append(",");
        }
        if (this.getTarget() != null) {
            sb.append("Target: ").append(this.getTarget()).append(",");
        }
        if (this.getTargetLocations() != null) {
            sb.append("TargetLocations: ").append(this.getTargetLocations()).append(",");
        }
        if (this.getProgressCounters() != null) {
            sb.append("ProgressCounters: ").append(this.getProgressCounters()).append(",");
        }
        if (this.getAlarmConfiguration() != null) {
            sb.append("AlarmConfiguration: ").append(this.getAlarmConfiguration()).append(",");
        }
        if (this.getTriggeredAlarms() != null) {
            sb.append("TriggeredAlarms: ").append(this.getTriggeredAlarms()).append(",");
        }
        if (this.getAutomationSubtype() != null) {
            sb.append("AutomationSubtype: ").append(this.getAutomationSubtype()).append(",");
        }
        if (this.getScheduledTime() != null) {
            sb.append("ScheduledTime: ").append(this.getScheduledTime()).append(",");
        }
        if (this.getRunbooks() != null) {
            sb.append("Runbooks: ").append(this.getRunbooks()).append(",");
        }
        if (this.getOpsItemId() != null) {
            sb.append("OpsItemId: ").append(this.getOpsItemId()).append(",");
        }
        if (this.getAssociationId() != null) {
            sb.append("AssociationId: ").append(this.getAssociationId()).append(",");
        }
        if (this.getChangeRequestName() != null) {
            sb.append("ChangeRequestName: ").append(this.getChangeRequestName()).append(",");
        }
        if (this.getVariables() != null) {
            sb.append("Variables: ").append(this.getVariables());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationExecution)) {
            return false;
        }
        AutomationExecution other = (AutomationExecution)obj;
        if (other.getAutomationExecutionId() == null ^ this.getAutomationExecutionId() == null) {
            return false;
        }
        if (other.getAutomationExecutionId() != null && !other.getAutomationExecutionId().equals(this.getAutomationExecutionId())) {
            return false;
        }
        if (other.getDocumentName() == null ^ this.getDocumentName() == null) {
            return false;
        }
        if (other.getDocumentName() != null && !other.getDocumentName().equals(this.getDocumentName())) {
            return false;
        }
        if (other.getDocumentVersion() == null ^ this.getDocumentVersion() == null) {
            return false;
        }
        if (other.getDocumentVersion() != null && !other.getDocumentVersion().equals(this.getDocumentVersion())) {
            return false;
        }
        if (other.getExecutionStartTime() == null ^ this.getExecutionStartTime() == null) {
            return false;
        }
        if (other.getExecutionStartTime() != null && !other.getExecutionStartTime().equals(this.getExecutionStartTime())) {
            return false;
        }
        if (other.getExecutionEndTime() == null ^ this.getExecutionEndTime() == null) {
            return false;
        }
        if (other.getExecutionEndTime() != null && !other.getExecutionEndTime().equals(this.getExecutionEndTime())) {
            return false;
        }
        if (other.getAutomationExecutionStatus() == null ^ this.getAutomationExecutionStatus() == null) {
            return false;
        }
        if (other.getAutomationExecutionStatus() != null && !other.getAutomationExecutionStatus().equals(this.getAutomationExecutionStatus())) {
            return false;
        }
        if (other.getStepExecutions() == null ^ this.getStepExecutions() == null) {
            return false;
        }
        if (other.getStepExecutions() != null && !other.getStepExecutions().equals(this.getStepExecutions())) {
            return false;
        }
        if (other.getStepExecutionsTruncated() == null ^ this.getStepExecutionsTruncated() == null) {
            return false;
        }
        if (other.getStepExecutionsTruncated() != null && !other.getStepExecutionsTruncated().equals(this.getStepExecutionsTruncated())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getOutputs() == null ^ this.getOutputs() == null) {
            return false;
        }
        if (other.getOutputs() != null && !other.getOutputs().equals(this.getOutputs())) {
            return false;
        }
        if (other.getFailureMessage() == null ^ this.getFailureMessage() == null) {
            return false;
        }
        if (other.getFailureMessage() != null && !other.getFailureMessage().equals(this.getFailureMessage())) {
            return false;
        }
        if (other.getMode() == null ^ this.getMode() == null) {
            return false;
        }
        if (other.getMode() != null && !other.getMode().equals(this.getMode())) {
            return false;
        }
        if (other.getParentAutomationExecutionId() == null ^ this.getParentAutomationExecutionId() == null) {
            return false;
        }
        if (other.getParentAutomationExecutionId() != null && !other.getParentAutomationExecutionId().equals(this.getParentAutomationExecutionId())) {
            return false;
        }
        if (other.getExecutedBy() == null ^ this.getExecutedBy() == null) {
            return false;
        }
        if (other.getExecutedBy() != null && !other.getExecutedBy().equals(this.getExecutedBy())) {
            return false;
        }
        if (other.getCurrentStepName() == null ^ this.getCurrentStepName() == null) {
            return false;
        }
        if (other.getCurrentStepName() != null && !other.getCurrentStepName().equals(this.getCurrentStepName())) {
            return false;
        }
        if (other.getCurrentAction() == null ^ this.getCurrentAction() == null) {
            return false;
        }
        if (other.getCurrentAction() != null && !other.getCurrentAction().equals(this.getCurrentAction())) {
            return false;
        }
        if (other.getTargetParameterName() == null ^ this.getTargetParameterName() == null) {
            return false;
        }
        if (other.getTargetParameterName() != null && !other.getTargetParameterName().equals(this.getTargetParameterName())) {
            return false;
        }
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        if (other.getTargets() != null && !other.getTargets().equals(this.getTargets())) {
            return false;
        }
        if (other.getTargetMaps() == null ^ this.getTargetMaps() == null) {
            return false;
        }
        if (other.getTargetMaps() != null && !other.getTargetMaps().equals(this.getTargetMaps())) {
            return false;
        }
        if (other.getResolvedTargets() == null ^ this.getResolvedTargets() == null) {
            return false;
        }
        if (other.getResolvedTargets() != null && !other.getResolvedTargets().equals(this.getResolvedTargets())) {
            return false;
        }
        if (other.getMaxConcurrency() == null ^ this.getMaxConcurrency() == null) {
            return false;
        }
        if (other.getMaxConcurrency() != null && !other.getMaxConcurrency().equals(this.getMaxConcurrency())) {
            return false;
        }
        if (other.getMaxErrors() == null ^ this.getMaxErrors() == null) {
            return false;
        }
        if (other.getMaxErrors() != null && !other.getMaxErrors().equals(this.getMaxErrors())) {
            return false;
        }
        if (other.getTarget() == null ^ this.getTarget() == null) {
            return false;
        }
        if (other.getTarget() != null && !other.getTarget().equals(this.getTarget())) {
            return false;
        }
        if (other.getTargetLocations() == null ^ this.getTargetLocations() == null) {
            return false;
        }
        if (other.getTargetLocations() != null && !other.getTargetLocations().equals(this.getTargetLocations())) {
            return false;
        }
        if (other.getProgressCounters() == null ^ this.getProgressCounters() == null) {
            return false;
        }
        if (other.getProgressCounters() != null && !other.getProgressCounters().equals(this.getProgressCounters())) {
            return false;
        }
        if (other.getAlarmConfiguration() == null ^ this.getAlarmConfiguration() == null) {
            return false;
        }
        if (other.getAlarmConfiguration() != null && !other.getAlarmConfiguration().equals(this.getAlarmConfiguration())) {
            return false;
        }
        if (other.getTriggeredAlarms() == null ^ this.getTriggeredAlarms() == null) {
            return false;
        }
        if (other.getTriggeredAlarms() != null && !other.getTriggeredAlarms().equals(this.getTriggeredAlarms())) {
            return false;
        }
        if (other.getAutomationSubtype() == null ^ this.getAutomationSubtype() == null) {
            return false;
        }
        if (other.getAutomationSubtype() != null && !other.getAutomationSubtype().equals(this.getAutomationSubtype())) {
            return false;
        }
        if (other.getScheduledTime() == null ^ this.getScheduledTime() == null) {
            return false;
        }
        if (other.getScheduledTime() != null && !other.getScheduledTime().equals(this.getScheduledTime())) {
            return false;
        }
        if (other.getRunbooks() == null ^ this.getRunbooks() == null) {
            return false;
        }
        if (other.getRunbooks() != null && !other.getRunbooks().equals(this.getRunbooks())) {
            return false;
        }
        if (other.getOpsItemId() == null ^ this.getOpsItemId() == null) {
            return false;
        }
        if (other.getOpsItemId() != null && !other.getOpsItemId().equals(this.getOpsItemId())) {
            return false;
        }
        if (other.getAssociationId() == null ^ this.getAssociationId() == null) {
            return false;
        }
        if (other.getAssociationId() != null && !other.getAssociationId().equals(this.getAssociationId())) {
            return false;
        }
        if (other.getChangeRequestName() == null ^ this.getChangeRequestName() == null) {
            return false;
        }
        if (other.getChangeRequestName() != null && !other.getChangeRequestName().equals(this.getChangeRequestName())) {
            return false;
        }
        if (other.getVariables() == null ^ this.getVariables() == null) {
            return false;
        }
        return other.getVariables() == null || other.getVariables().equals(this.getVariables());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAutomationExecutionId() == null ? 0 : this.getAutomationExecutionId().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentName() == null ? 0 : this.getDocumentName().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentVersion() == null ? 0 : this.getDocumentVersion().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionStartTime() == null ? 0 : this.getExecutionStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionEndTime() == null ? 0 : this.getExecutionEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getAutomationExecutionStatus() == null ? 0 : this.getAutomationExecutionStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStepExecutions() == null ? 0 : this.getStepExecutions().hashCode());
        hashCode = 31 * hashCode + (this.getStepExecutionsTruncated() == null ? 0 : this.getStepExecutionsTruncated().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getOutputs() == null ? 0 : this.getOutputs().hashCode());
        hashCode = 31 * hashCode + (this.getFailureMessage() == null ? 0 : this.getFailureMessage().hashCode());
        hashCode = 31 * hashCode + (this.getMode() == null ? 0 : this.getMode().hashCode());
        hashCode = 31 * hashCode + (this.getParentAutomationExecutionId() == null ? 0 : this.getParentAutomationExecutionId().hashCode());
        hashCode = 31 * hashCode + (this.getExecutedBy() == null ? 0 : this.getExecutedBy().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentStepName() == null ? 0 : this.getCurrentStepName().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentAction() == null ? 0 : this.getCurrentAction().hashCode());
        hashCode = 31 * hashCode + (this.getTargetParameterName() == null ? 0 : this.getTargetParameterName().hashCode());
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        hashCode = 31 * hashCode + (this.getTargetMaps() == null ? 0 : this.getTargetMaps().hashCode());
        hashCode = 31 * hashCode + (this.getResolvedTargets() == null ? 0 : this.getResolvedTargets().hashCode());
        hashCode = 31 * hashCode + (this.getMaxConcurrency() == null ? 0 : this.getMaxConcurrency().hashCode());
        hashCode = 31 * hashCode + (this.getMaxErrors() == null ? 0 : this.getMaxErrors().hashCode());
        hashCode = 31 * hashCode + (this.getTarget() == null ? 0 : this.getTarget().hashCode());
        hashCode = 31 * hashCode + (this.getTargetLocations() == null ? 0 : this.getTargetLocations().hashCode());
        hashCode = 31 * hashCode + (this.getProgressCounters() == null ? 0 : this.getProgressCounters().hashCode());
        hashCode = 31 * hashCode + (this.getAlarmConfiguration() == null ? 0 : this.getAlarmConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getTriggeredAlarms() == null ? 0 : this.getTriggeredAlarms().hashCode());
        hashCode = 31 * hashCode + (this.getAutomationSubtype() == null ? 0 : this.getAutomationSubtype().hashCode());
        hashCode = 31 * hashCode + (this.getScheduledTime() == null ? 0 : this.getScheduledTime().hashCode());
        hashCode = 31 * hashCode + (this.getRunbooks() == null ? 0 : this.getRunbooks().hashCode());
        hashCode = 31 * hashCode + (this.getOpsItemId() == null ? 0 : this.getOpsItemId().hashCode());
        hashCode = 31 * hashCode + (this.getAssociationId() == null ? 0 : this.getAssociationId().hashCode());
        hashCode = 31 * hashCode + (this.getChangeRequestName() == null ? 0 : this.getChangeRequestName().hashCode());
        hashCode = 31 * hashCode + (this.getVariables() == null ? 0 : this.getVariables().hashCode());
        return hashCode;
    }

    public AutomationExecution clone() {
        try {
            return (AutomationExecution)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutomationExecutionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

