/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simspaceweaver.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.simspaceweaver.model.SimulationMetadata;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListSimulationsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<SimulationMetadata> simulations;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListSimulationsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<SimulationMetadata> getSimulations() {
        return this.simulations;
    }

    public void setSimulations(Collection<SimulationMetadata> simulations) {
        if (simulations == null) {
            this.simulations = null;
            return;
        }
        this.simulations = new ArrayList<SimulationMetadata>(simulations);
    }

    public ListSimulationsResult withSimulations(SimulationMetadata ... simulations) {
        if (this.simulations == null) {
            this.setSimulations(new ArrayList<SimulationMetadata>(simulations.length));
        }
        for (SimulationMetadata ele : simulations) {
            this.simulations.add(ele);
        }
        return this;
    }

    public ListSimulationsResult withSimulations(Collection<SimulationMetadata> simulations) {
        this.setSimulations(simulations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getSimulations() != null) {
            sb.append("Simulations: ").append(this.getSimulations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSimulationsResult)) {
            return false;
        }
        ListSimulationsResult other = (ListSimulationsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getSimulations() == null ^ this.getSimulations() == null) {
            return false;
        }
        return other.getSimulations() == null || other.getSimulations().equals(this.getSimulations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getSimulations() == null ? 0 : this.getSimulations().hashCode());
        return hashCode;
    }

    public ListSimulationsResult clone() {
        try {
            return (ListSimulationsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

