/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.route53.model.AliasTarget;
import com.amazonaws.services.route53.model.Change;
import com.amazonaws.services.route53.model.ChangeBatch;
import com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest;
import com.amazonaws.services.route53.model.CidrRoutingConfig;
import com.amazonaws.services.route53.model.Coordinates;
import com.amazonaws.services.route53.model.GeoLocation;
import com.amazonaws.services.route53.model.GeoProximityLocation;
import com.amazonaws.services.route53.model.ResourceRecord;
import com.amazonaws.services.route53.model.ResourceRecordSet;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class ChangeResourceRecordSetsRequestMarshaller
implements Marshaller<Request<ChangeResourceRecordSetsRequest>, ChangeResourceRecordSetsRequest> {
    public Request<ChangeResourceRecordSetsRequest> marshall(ChangeResourceRecordSetsRequest changeResourceRecordSetsRequest) {
        if (changeResourceRecordSetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)changeResourceRecordSetsRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2013-04-01/hostedzone/{Id}/rrset/";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Id", changeResourceRecordSetsRequest.getHostedZoneId());
        request.setResourcePath(uriResourcePath);
        try {
            ChangeBatch changeBatch;
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");
            xmlWriter.startElement("ChangeResourceRecordSetsRequest");
            if (changeResourceRecordSetsRequest != null && (changeBatch = changeResourceRecordSetsRequest.getChangeBatch()) != null) {
                SdkInternalList changeBatchChangesList;
                xmlWriter.startElement("ChangeBatch");
                if (changeBatch.getComment() != null) {
                    xmlWriter.startElement("Comment").value(changeBatch.getComment()).endElement();
                }
                if (!(changeBatchChangesList = (SdkInternalList)changeBatch.getChanges()).isEmpty() || !changeBatchChangesList.isAutoConstruct()) {
                    xmlWriter.startElement("Changes");
                    for (Change changeBatchChangesListValue : changeBatchChangesList) {
                        ResourceRecordSet resourceRecordSet;
                        xmlWriter.startElement("Change");
                        if (changeBatchChangesListValue.getAction() != null) {
                            xmlWriter.startElement("Action").value(changeBatchChangesListValue.getAction()).endElement();
                        }
                        if ((resourceRecordSet = changeBatchChangesListValue.getResourceRecordSet()) != null) {
                            GeoProximityLocation geoProximityLocation;
                            CidrRoutingConfig cidrRoutingConfig;
                            AliasTarget aliasTarget;
                            SdkInternalList resourceRecordSetResourceRecordsList;
                            GeoLocation geoLocation;
                            xmlWriter.startElement("ResourceRecordSet");
                            if (resourceRecordSet.getName() != null) {
                                xmlWriter.startElement("Name").value(resourceRecordSet.getName()).endElement();
                            }
                            if (resourceRecordSet.getType() != null) {
                                xmlWriter.startElement("Type").value(resourceRecordSet.getType()).endElement();
                            }
                            if (resourceRecordSet.getSetIdentifier() != null) {
                                xmlWriter.startElement("SetIdentifier").value(resourceRecordSet.getSetIdentifier()).endElement();
                            }
                            if (resourceRecordSet.getWeight() != null) {
                                xmlWriter.startElement("Weight").value((Object)resourceRecordSet.getWeight()).endElement();
                            }
                            if (resourceRecordSet.getRegion() != null) {
                                xmlWriter.startElement("Region").value(resourceRecordSet.getRegion()).endElement();
                            }
                            if ((geoLocation = resourceRecordSet.getGeoLocation()) != null) {
                                xmlWriter.startElement("GeoLocation");
                                if (geoLocation.getContinentCode() != null) {
                                    xmlWriter.startElement("ContinentCode").value(geoLocation.getContinentCode()).endElement();
                                }
                                if (geoLocation.getCountryCode() != null) {
                                    xmlWriter.startElement("CountryCode").value(geoLocation.getCountryCode()).endElement();
                                }
                                if (geoLocation.getSubdivisionCode() != null) {
                                    xmlWriter.startElement("SubdivisionCode").value(geoLocation.getSubdivisionCode()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if (resourceRecordSet.getFailover() != null) {
                                xmlWriter.startElement("Failover").value(resourceRecordSet.getFailover()).endElement();
                            }
                            if (resourceRecordSet.getMultiValueAnswer() != null) {
                                xmlWriter.startElement("MultiValueAnswer").value((Object)resourceRecordSet.getMultiValueAnswer()).endElement();
                            }
                            if (resourceRecordSet.getTTL() != null) {
                                xmlWriter.startElement("TTL").value((Object)resourceRecordSet.getTTL()).endElement();
                            }
                            if (!(resourceRecordSetResourceRecordsList = (SdkInternalList)resourceRecordSet.getResourceRecords()).isEmpty() || !resourceRecordSetResourceRecordsList.isAutoConstruct()) {
                                xmlWriter.startElement("ResourceRecords");
                                for (ResourceRecord resourceRecordSetResourceRecordsListValue : resourceRecordSetResourceRecordsList) {
                                    xmlWriter.startElement("ResourceRecord");
                                    if (resourceRecordSetResourceRecordsListValue.getValue() != null) {
                                        xmlWriter.startElement("Value").value(resourceRecordSetResourceRecordsListValue.getValue()).endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((aliasTarget = resourceRecordSet.getAliasTarget()) != null) {
                                xmlWriter.startElement("AliasTarget");
                                if (aliasTarget.getHostedZoneId() != null) {
                                    xmlWriter.startElement("HostedZoneId").value(aliasTarget.getHostedZoneId()).endElement();
                                }
                                if (aliasTarget.getDNSName() != null) {
                                    xmlWriter.startElement("DNSName").value(aliasTarget.getDNSName()).endElement();
                                }
                                if (aliasTarget.getEvaluateTargetHealth() != null) {
                                    xmlWriter.startElement("EvaluateTargetHealth").value((Object)aliasTarget.getEvaluateTargetHealth()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if (resourceRecordSet.getHealthCheckId() != null) {
                                xmlWriter.startElement("HealthCheckId").value(resourceRecordSet.getHealthCheckId()).endElement();
                            }
                            if (resourceRecordSet.getTrafficPolicyInstanceId() != null) {
                                xmlWriter.startElement("TrafficPolicyInstanceId").value(resourceRecordSet.getTrafficPolicyInstanceId()).endElement();
                            }
                            if ((cidrRoutingConfig = resourceRecordSet.getCidrRoutingConfig()) != null) {
                                xmlWriter.startElement("CidrRoutingConfig");
                                if (cidrRoutingConfig.getCollectionId() != null) {
                                    xmlWriter.startElement("CollectionId").value(cidrRoutingConfig.getCollectionId()).endElement();
                                }
                                if (cidrRoutingConfig.getLocationName() != null) {
                                    xmlWriter.startElement("LocationName").value(cidrRoutingConfig.getLocationName()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((geoProximityLocation = resourceRecordSet.getGeoProximityLocation()) != null) {
                                Coordinates coordinates;
                                xmlWriter.startElement("GeoProximityLocation");
                                if (geoProximityLocation.getAWSRegion() != null) {
                                    xmlWriter.startElement("AWSRegion").value(geoProximityLocation.getAWSRegion()).endElement();
                                }
                                if (geoProximityLocation.getLocalZoneGroup() != null) {
                                    xmlWriter.startElement("LocalZoneGroup").value(geoProximityLocation.getLocalZoneGroup()).endElement();
                                }
                                if ((coordinates = geoProximityLocation.getCoordinates()) != null) {
                                    xmlWriter.startElement("Coordinates");
                                    if (coordinates.getLatitude() != null) {
                                        xmlWriter.startElement("Latitude").value(coordinates.getLatitude()).endElement();
                                    }
                                    if (coordinates.getLongitude() != null) {
                                        xmlWriter.startElement("Longitude").value(coordinates.getLongitude()).endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                if (geoProximityLocation.getBias() != null) {
                                    xmlWriter.startElement("Bias").value((Object)geoProximityLocation.getBias()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

