/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.redshiftserverless.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetScheduledAction"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetScheduledActionResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The returned scheduled action object.
     * </p>
     */
    private ScheduledActionResponse scheduledAction;

    /**
     * <p>
     * The returned scheduled action object.
     * </p>
     * 
     * @param scheduledAction
     *        The returned scheduled action object.
     */

    public void setScheduledAction(ScheduledActionResponse scheduledAction) {
        this.scheduledAction = scheduledAction;
    }

    /**
     * <p>
     * The returned scheduled action object.
     * </p>
     * 
     * @return The returned scheduled action object.
     */

    public ScheduledActionResponse getScheduledAction() {
        return this.scheduledAction;
    }

    /**
     * <p>
     * The returned scheduled action object.
     * </p>
     * 
     * @param scheduledAction
     *        The returned scheduled action object.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetScheduledActionResult withScheduledAction(ScheduledActionResponse scheduledAction) {
        setScheduledAction(scheduledAction);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getScheduledAction() != null)
            sb.append("ScheduledAction: ").append(getScheduledAction());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetScheduledActionResult == false)
            return false;
        GetScheduledActionResult other = (GetScheduledActionResult) obj;
        if (other.getScheduledAction() == null ^ this.getScheduledAction() == null)
            return false;
        if (other.getScheduledAction() != null && other.getScheduledAction().equals(this.getScheduledAction()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getScheduledAction() == null) ? 0 : getScheduledAction().hashCode());
        return hashCode;
    }

    @Override
    public GetScheduledActionResult clone() {
        try {
            return (GetScheduledActionResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
