/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.quicksight.model.WordCloudOptions;

@SdkInternalApi
public class WordCloudOptionsMarshaller {
    private static final MarshallingInfo<String> WORDORIENTATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WordOrientation").build();
    private static final MarshallingInfo<String> WORDSCALING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WordScaling").build();
    private static final MarshallingInfo<String> CLOUDLAYOUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CloudLayout").build();
    private static final MarshallingInfo<String> WORDCASING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WordCasing").build();
    private static final MarshallingInfo<String> WORDPADDING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WordPadding").build();
    private static final MarshallingInfo<Integer> MAXIMUMSTRINGLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaximumStringLength").build();
    private static final WordCloudOptionsMarshaller instance = new WordCloudOptionsMarshaller();

    public static WordCloudOptionsMarshaller getInstance() {
        return instance;
    }

    public void marshall(WordCloudOptions wordCloudOptions, ProtocolMarshaller protocolMarshaller) {
        if (wordCloudOptions == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)wordCloudOptions.getWordOrientation(), WORDORIENTATION_BINDING);
            protocolMarshaller.marshall((Object)wordCloudOptions.getWordScaling(), WORDSCALING_BINDING);
            protocolMarshaller.marshall((Object)wordCloudOptions.getCloudLayout(), CLOUDLAYOUT_BINDING);
            protocolMarshaller.marshall((Object)wordCloudOptions.getWordCasing(), WORDCASING_BINDING);
            protocolMarshaller.marshall((Object)wordCloudOptions.getWordPadding(), WORDPADDING_BINDING);
            protocolMarshaller.marshall((Object)wordCloudOptions.getMaximumStringLength(), MAXIMUMSTRINGLENGTH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

