/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.quicksight.model.PaginationConfiguration;

@SdkInternalApi
public class PaginationConfigurationMarshaller {
    private static final MarshallingInfo<Long> PAGESIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PageSize").build();
    private static final MarshallingInfo<Long> PAGENUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PageNumber").build();
    private static final PaginationConfigurationMarshaller instance = new PaginationConfigurationMarshaller();

    public static PaginationConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(PaginationConfiguration paginationConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (paginationConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)paginationConfiguration.getPageSize(), PAGESIZE_BINDING);
            protocolMarshaller.marshall((Object)paginationConfiguration.getPageNumber(), PAGENUMBER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

