/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.quicksight.model.NewDefaultValues;
import java.util.List;

@SdkInternalApi
public class NewDefaultValuesMarshaller {
    private static final MarshallingInfo<List> STRINGSTATICVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StringStaticValues").build();
    private static final MarshallingInfo<List> DECIMALSTATICVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DecimalStaticValues").build();
    private static final MarshallingInfo<List> DATETIMESTATICVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DateTimeStaticValues").build();
    private static final MarshallingInfo<List> INTEGERSTATICVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IntegerStaticValues").build();
    private static final NewDefaultValuesMarshaller instance = new NewDefaultValuesMarshaller();

    public static NewDefaultValuesMarshaller getInstance() {
        return instance;
    }

    public void marshall(NewDefaultValues newDefaultValues, ProtocolMarshaller protocolMarshaller) {
        if (newDefaultValues == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(newDefaultValues.getStringStaticValues(), STRINGSTATICVALUES_BINDING);
            protocolMarshaller.marshall(newDefaultValues.getDecimalStaticValues(), DECIMALSTATICVALUES_BINDING);
            protocolMarshaller.marshall(newDefaultValues.getDateTimeStaticValues(), DATETIMESTATICVALUES_BINDING);
            protocolMarshaller.marshall(newDefaultValues.getIntegerStaticValues(), INTEGERSTATICVALUES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

