/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.quicksight.model.DataPathSort;
import java.util.List;

@SdkInternalApi
public class DataPathSortMarshaller {
    private static final MarshallingInfo<String> DIRECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Direction").build();
    private static final MarshallingInfo<List> SORTPATHS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SortPaths").build();
    private static final DataPathSortMarshaller instance = new DataPathSortMarshaller();

    public static DataPathSortMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataPathSort dataPathSort, ProtocolMarshaller protocolMarshaller) {
        if (dataPathSort == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dataPathSort.getDirection(), DIRECTION_BINDING);
            protocolMarshaller.marshall(dataPathSort.getSortPaths(), SORTPATHS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

