/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.CollectiveConstantEntry;
import com.amazonaws.services.quicksight.model.ConstantType;
import com.amazonaws.services.quicksight.model.transform.TopicConstantValueMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TopicConstantValue
implements Serializable,
Cloneable,
StructuredPojo {
    private String constantType;
    private String value;
    private String minimum;
    private String maximum;
    private List<CollectiveConstantEntry> valueList;

    public void setConstantType(String constantType) {
        this.constantType = constantType;
    }

    public String getConstantType() {
        return this.constantType;
    }

    public TopicConstantValue withConstantType(String constantType) {
        this.setConstantType(constantType);
        return this;
    }

    public TopicConstantValue withConstantType(ConstantType constantType) {
        this.constantType = constantType.toString();
        return this;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public TopicConstantValue withValue(String value) {
        this.setValue(value);
        return this;
    }

    public void setMinimum(String minimum) {
        this.minimum = minimum;
    }

    public String getMinimum() {
        return this.minimum;
    }

    public TopicConstantValue withMinimum(String minimum) {
        this.setMinimum(minimum);
        return this;
    }

    public void setMaximum(String maximum) {
        this.maximum = maximum;
    }

    public String getMaximum() {
        return this.maximum;
    }

    public TopicConstantValue withMaximum(String maximum) {
        this.setMaximum(maximum);
        return this;
    }

    public List<CollectiveConstantEntry> getValueList() {
        return this.valueList;
    }

    public void setValueList(Collection<CollectiveConstantEntry> valueList) {
        if (valueList == null) {
            this.valueList = null;
            return;
        }
        this.valueList = new ArrayList<CollectiveConstantEntry>(valueList);
    }

    public TopicConstantValue withValueList(CollectiveConstantEntry ... valueList) {
        if (this.valueList == null) {
            this.setValueList(new ArrayList<CollectiveConstantEntry>(valueList.length));
        }
        for (CollectiveConstantEntry ele : valueList) {
            this.valueList.add(ele);
        }
        return this;
    }

    public TopicConstantValue withValueList(Collection<CollectiveConstantEntry> valueList) {
        this.setValueList(valueList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConstantType() != null) {
            sb.append("ConstantType: ").append(this.getConstantType()).append(",");
        }
        if (this.getValue() != null) {
            sb.append("Value: ").append(this.getValue()).append(",");
        }
        if (this.getMinimum() != null) {
            sb.append("Minimum: ").append(this.getMinimum()).append(",");
        }
        if (this.getMaximum() != null) {
            sb.append("Maximum: ").append(this.getMaximum()).append(",");
        }
        if (this.getValueList() != null) {
            sb.append("ValueList: ").append(this.getValueList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicConstantValue)) {
            return false;
        }
        TopicConstantValue other = (TopicConstantValue)obj;
        if (other.getConstantType() == null ^ this.getConstantType() == null) {
            return false;
        }
        if (other.getConstantType() != null && !other.getConstantType().equals(this.getConstantType())) {
            return false;
        }
        if (other.getValue() == null ^ this.getValue() == null) {
            return false;
        }
        if (other.getValue() != null && !other.getValue().equals(this.getValue())) {
            return false;
        }
        if (other.getMinimum() == null ^ this.getMinimum() == null) {
            return false;
        }
        if (other.getMinimum() != null && !other.getMinimum().equals(this.getMinimum())) {
            return false;
        }
        if (other.getMaximum() == null ^ this.getMaximum() == null) {
            return false;
        }
        if (other.getMaximum() != null && !other.getMaximum().equals(this.getMaximum())) {
            return false;
        }
        if (other.getValueList() == null ^ this.getValueList() == null) {
            return false;
        }
        return other.getValueList() == null || other.getValueList().equals(this.getValueList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConstantType() == null ? 0 : this.getConstantType().hashCode());
        hashCode = 31 * hashCode + (this.getValue() == null ? 0 : this.getValue().hashCode());
        hashCode = 31 * hashCode + (this.getMinimum() == null ? 0 : this.getMinimum().hashCode());
        hashCode = 31 * hashCode + (this.getMaximum() == null ? 0 : this.getMaximum().hashCode());
        hashCode = 31 * hashCode + (this.getValueList() == null ? 0 : this.getValueList().hashCode());
        return hashCode;
    }

    public TopicConstantValue clone() {
        try {
            return (TopicConstantValue)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TopicConstantValueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

