/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.transform.PaginationConfigurationMarshaller;
import java.io.Serializable;

public class PaginationConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private Long pageSize;
    private Long pageNumber;

    public void setPageSize(Long pageSize) {
        this.pageSize = pageSize;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public PaginationConfiguration withPageSize(Long pageSize) {
        this.setPageSize(pageSize);
        return this;
    }

    public void setPageNumber(Long pageNumber) {
        this.pageNumber = pageNumber;
    }

    public Long getPageNumber() {
        return this.pageNumber;
    }

    public PaginationConfiguration withPageNumber(Long pageNumber) {
        this.setPageNumber(pageNumber);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPageSize() != null) {
            sb.append("PageSize: ").append(this.getPageSize()).append(",");
        }
        if (this.getPageNumber() != null) {
            sb.append("PageNumber: ").append(this.getPageNumber());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PaginationConfiguration)) {
            return false;
        }
        PaginationConfiguration other = (PaginationConfiguration)obj;
        if (other.getPageSize() == null ^ this.getPageSize() == null) {
            return false;
        }
        if (other.getPageSize() != null && !other.getPageSize().equals(this.getPageSize())) {
            return false;
        }
        if (other.getPageNumber() == null ^ this.getPageNumber() == null) {
            return false;
        }
        return other.getPageNumber() == null || other.getPageNumber().equals(this.getPageNumber());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPageSize() == null ? 0 : this.getPageSize().hashCode());
        hashCode = 31 * hashCode + (this.getPageNumber() == null ? 0 : this.getPageNumber().hashCode());
        return hashCode;
    }

    public PaginationConfiguration clone() {
        try {
            return (PaginationConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PaginationConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

