/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.omics.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.omics.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * RunGroupListItem JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class RunGroupListItemJsonUnmarshaller implements Unmarshaller<RunGroupListItem, JsonUnmarshallerContext> {

    public RunGroupListItem unmarshall(JsonUnmarshallerContext context) throws Exception {
        RunGroupListItem runGroupListItem = new RunGroupListItem();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    runGroupListItem.setArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("id", targetDepth)) {
                    context.nextToken();
                    runGroupListItem.setId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    runGroupListItem.setName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("maxCpus", targetDepth)) {
                    context.nextToken();
                    runGroupListItem.setMaxCpus(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("maxRuns", targetDepth)) {
                    context.nextToken();
                    runGroupListItem.setMaxRuns(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("maxDuration", targetDepth)) {
                    context.nextToken();
                    runGroupListItem.setMaxDuration(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("creationTime", targetDepth)) {
                    context.nextToken();
                    runGroupListItem.setCreationTime(DateJsonUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                }
                if (context.testExpression("maxGpus", targetDepth)) {
                    context.nextToken();
                    runGroupListItem.setMaxGpus(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return runGroupListItem;
    }

    private static RunGroupListItemJsonUnmarshaller instance;

    public static RunGroupListItemJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new RunGroupListItemJsonUnmarshaller();
        return instance;
    }
}
