/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mturk.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mturk.model.Locale;

@SdkInternalApi
public class LocaleMarshaller {
    private static final MarshallingInfo<String> COUNTRY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Country").build();
    private static final MarshallingInfo<String> SUBDIVISION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Subdivision").build();
    private static final LocaleMarshaller instance = new LocaleMarshaller();

    public static LocaleMarshaller getInstance() {
        return instance;
    }

    public void marshall(Locale locale, ProtocolMarshaller protocolMarshaller) {
        if (locale == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)locale.getCountry(), COUNTRY_BINDING);
            protocolMarshaller.marshall((Object)locale.getSubdivision(), SUBDIVISION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

