/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.marketplacecatalog.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.marketplacecatalog.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * ResaleAuthorizationManufacturerLegalNameFilterMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class ResaleAuthorizationManufacturerLegalNameFilterMarshaller {

    private static final MarshallingInfo<List> VALUELIST_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ValueList").build();
    private static final MarshallingInfo<String> WILDCARDVALUE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WildCardValue").build();

    private static final ResaleAuthorizationManufacturerLegalNameFilterMarshaller instance = new ResaleAuthorizationManufacturerLegalNameFilterMarshaller();

    public static ResaleAuthorizationManufacturerLegalNameFilterMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(ResaleAuthorizationManufacturerLegalNameFilter resaleAuthorizationManufacturerLegalNameFilter, ProtocolMarshaller protocolMarshaller) {

        if (resaleAuthorizationManufacturerLegalNameFilter == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(resaleAuthorizationManufacturerLegalNameFilter.getValueList(), VALUELIST_BINDING);
            protocolMarshaller.marshall(resaleAuthorizationManufacturerLegalNameFilter.getWildCardValue(), WILDCARDVALUE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
