/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.imagebuilder.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.imagebuilder.model.LifecycleExecutionResourceAction;
import com.amazonaws.services.imagebuilder.model.LifecycleExecutionResourceState;
import com.amazonaws.services.imagebuilder.model.LifecycleExecutionSnapshotResource;
import com.amazonaws.services.imagebuilder.model.transform.LifecycleExecutionResourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class LifecycleExecutionResource
implements Serializable,
Cloneable,
StructuredPojo {
    private String accountId;
    private String resourceId;
    private LifecycleExecutionResourceState state;
    private LifecycleExecutionResourceAction action;
    private String region;
    private List<LifecycleExecutionSnapshotResource> snapshots;
    private List<String> imageUris;
    private Date startTime;
    private Date endTime;

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public LifecycleExecutionResource withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public LifecycleExecutionResource withResourceId(String resourceId) {
        this.setResourceId(resourceId);
        return this;
    }

    public void setState(LifecycleExecutionResourceState state) {
        this.state = state;
    }

    public LifecycleExecutionResourceState getState() {
        return this.state;
    }

    public LifecycleExecutionResource withState(LifecycleExecutionResourceState state) {
        this.setState(state);
        return this;
    }

    public void setAction(LifecycleExecutionResourceAction action) {
        this.action = action;
    }

    public LifecycleExecutionResourceAction getAction() {
        return this.action;
    }

    public LifecycleExecutionResource withAction(LifecycleExecutionResourceAction action) {
        this.setAction(action);
        return this;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegion() {
        return this.region;
    }

    public LifecycleExecutionResource withRegion(String region) {
        this.setRegion(region);
        return this;
    }

    public List<LifecycleExecutionSnapshotResource> getSnapshots() {
        return this.snapshots;
    }

    public void setSnapshots(Collection<LifecycleExecutionSnapshotResource> snapshots) {
        if (snapshots == null) {
            this.snapshots = null;
            return;
        }
        this.snapshots = new ArrayList<LifecycleExecutionSnapshotResource>(snapshots);
    }

    public LifecycleExecutionResource withSnapshots(LifecycleExecutionSnapshotResource ... snapshots) {
        if (this.snapshots == null) {
            this.setSnapshots(new ArrayList<LifecycleExecutionSnapshotResource>(snapshots.length));
        }
        for (LifecycleExecutionSnapshotResource ele : snapshots) {
            this.snapshots.add(ele);
        }
        return this;
    }

    public LifecycleExecutionResource withSnapshots(Collection<LifecycleExecutionSnapshotResource> snapshots) {
        this.setSnapshots(snapshots);
        return this;
    }

    public List<String> getImageUris() {
        return this.imageUris;
    }

    public void setImageUris(Collection<String> imageUris) {
        if (imageUris == null) {
            this.imageUris = null;
            return;
        }
        this.imageUris = new ArrayList<String>(imageUris);
    }

    public LifecycleExecutionResource withImageUris(String ... imageUris) {
        if (this.imageUris == null) {
            this.setImageUris(new ArrayList<String>(imageUris.length));
        }
        for (String ele : imageUris) {
            this.imageUris.add(ele);
        }
        return this;
    }

    public LifecycleExecutionResource withImageUris(Collection<String> imageUris) {
        this.setImageUris(imageUris);
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public LifecycleExecutionResource withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public LifecycleExecutionResource withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getResourceId() != null) {
            sb.append("ResourceId: ").append(this.getResourceId()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getAction() != null) {
            sb.append("Action: ").append(this.getAction()).append(",");
        }
        if (this.getRegion() != null) {
            sb.append("Region: ").append(this.getRegion()).append(",");
        }
        if (this.getSnapshots() != null) {
            sb.append("Snapshots: ").append(this.getSnapshots()).append(",");
        }
        if (this.getImageUris() != null) {
            sb.append("ImageUris: ").append(this.getImageUris()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleExecutionResource)) {
            return false;
        }
        LifecycleExecutionResource other = (LifecycleExecutionResource)obj;
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getResourceId() == null ^ this.getResourceId() == null) {
            return false;
        }
        if (other.getResourceId() != null && !other.getResourceId().equals(this.getResourceId())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getAction() == null ^ this.getAction() == null) {
            return false;
        }
        if (other.getAction() != null && !other.getAction().equals(this.getAction())) {
            return false;
        }
        if (other.getRegion() == null ^ this.getRegion() == null) {
            return false;
        }
        if (other.getRegion() != null && !other.getRegion().equals(this.getRegion())) {
            return false;
        }
        if (other.getSnapshots() == null ^ this.getSnapshots() == null) {
            return false;
        }
        if (other.getSnapshots() != null && !other.getSnapshots().equals(this.getSnapshots())) {
            return false;
        }
        if (other.getImageUris() == null ^ this.getImageUris() == null) {
            return false;
        }
        if (other.getImageUris() != null && !other.getImageUris().equals(this.getImageUris())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        return other.getEndTime() == null || other.getEndTime().equals(this.getEndTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getResourceId() == null ? 0 : this.getResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getAction() == null ? 0 : this.getAction().hashCode());
        hashCode = 31 * hashCode + (this.getRegion() == null ? 0 : this.getRegion().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshots() == null ? 0 : this.getSnapshots().hashCode());
        hashCode = 31 * hashCode + (this.getImageUris() == null ? 0 : this.getImageUris().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        return hashCode;
    }

    public LifecycleExecutionResource clone() {
        try {
            return (LifecycleExecutionResource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LifecycleExecutionResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

