/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.guardduty.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.guardduty.model.ItemPath;
import com.amazonaws.services.guardduty.model.transform.ThreatMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Threat
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String source;
    private List<ItemPath> itemPaths;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Threat withName(String name) {
        this.setName(name);
        return this;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public Threat withSource(String source) {
        this.setSource(source);
        return this;
    }

    public List<ItemPath> getItemPaths() {
        return this.itemPaths;
    }

    public void setItemPaths(Collection<ItemPath> itemPaths) {
        if (itemPaths == null) {
            this.itemPaths = null;
            return;
        }
        this.itemPaths = new ArrayList<ItemPath>(itemPaths);
    }

    public Threat withItemPaths(ItemPath ... itemPaths) {
        if (this.itemPaths == null) {
            this.setItemPaths(new ArrayList<ItemPath>(itemPaths.length));
        }
        for (ItemPath ele : itemPaths) {
            this.itemPaths.add(ele);
        }
        return this;
    }

    public Threat withItemPaths(Collection<ItemPath> itemPaths) {
        this.setItemPaths(itemPaths);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource()).append(",");
        }
        if (this.getItemPaths() != null) {
            sb.append("ItemPaths: ").append(this.getItemPaths());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Threat)) {
            return false;
        }
        Threat other = (Threat)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getItemPaths() == null ^ this.getItemPaths() == null) {
            return false;
        }
        return other.getItemPaths() == null || other.getItemPaths().equals(this.getItemPaths());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getItemPaths() == null ? 0 : this.getItemPaths().hashCode());
        return hashCode;
    }

    public Threat clone() {
        try {
            return (Threat)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ThreatMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

