/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.guardduty.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.guardduty.model.ResourceDetails;
import com.amazonaws.services.guardduty.model.ScanResultDetails;
import com.amazonaws.services.guardduty.model.ScanStatus;
import com.amazonaws.services.guardduty.model.ScanType;
import com.amazonaws.services.guardduty.model.TriggerDetails;
import com.amazonaws.services.guardduty.model.VolumeDetail;
import com.amazonaws.services.guardduty.model.transform.ScanMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Scan
implements Serializable,
Cloneable,
StructuredPojo {
    private String detectorId;
    private String adminDetectorId;
    private String scanId;
    private String scanStatus;
    private String failureReason;
    private Date scanStartTime;
    private Date scanEndTime;
    private TriggerDetails triggerDetails;
    private ResourceDetails resourceDetails;
    private ScanResultDetails scanResultDetails;
    private String accountId;
    private Long totalBytes;
    private Long fileCount;
    private List<VolumeDetail> attachedVolumes;
    private String scanType;

    public void setDetectorId(String detectorId) {
        this.detectorId = detectorId;
    }

    public String getDetectorId() {
        return this.detectorId;
    }

    public Scan withDetectorId(String detectorId) {
        this.setDetectorId(detectorId);
        return this;
    }

    public void setAdminDetectorId(String adminDetectorId) {
        this.adminDetectorId = adminDetectorId;
    }

    public String getAdminDetectorId() {
        return this.adminDetectorId;
    }

    public Scan withAdminDetectorId(String adminDetectorId) {
        this.setAdminDetectorId(adminDetectorId);
        return this;
    }

    public void setScanId(String scanId) {
        this.scanId = scanId;
    }

    public String getScanId() {
        return this.scanId;
    }

    public Scan withScanId(String scanId) {
        this.setScanId(scanId);
        return this;
    }

    public void setScanStatus(String scanStatus) {
        this.scanStatus = scanStatus;
    }

    public String getScanStatus() {
        return this.scanStatus;
    }

    public Scan withScanStatus(String scanStatus) {
        this.setScanStatus(scanStatus);
        return this;
    }

    public Scan withScanStatus(ScanStatus scanStatus) {
        this.scanStatus = scanStatus.toString();
        return this;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public Scan withFailureReason(String failureReason) {
        this.setFailureReason(failureReason);
        return this;
    }

    public void setScanStartTime(Date scanStartTime) {
        this.scanStartTime = scanStartTime;
    }

    public Date getScanStartTime() {
        return this.scanStartTime;
    }

    public Scan withScanStartTime(Date scanStartTime) {
        this.setScanStartTime(scanStartTime);
        return this;
    }

    public void setScanEndTime(Date scanEndTime) {
        this.scanEndTime = scanEndTime;
    }

    public Date getScanEndTime() {
        return this.scanEndTime;
    }

    public Scan withScanEndTime(Date scanEndTime) {
        this.setScanEndTime(scanEndTime);
        return this;
    }

    public void setTriggerDetails(TriggerDetails triggerDetails) {
        this.triggerDetails = triggerDetails;
    }

    public TriggerDetails getTriggerDetails() {
        return this.triggerDetails;
    }

    public Scan withTriggerDetails(TriggerDetails triggerDetails) {
        this.setTriggerDetails(triggerDetails);
        return this;
    }

    public void setResourceDetails(ResourceDetails resourceDetails) {
        this.resourceDetails = resourceDetails;
    }

    public ResourceDetails getResourceDetails() {
        return this.resourceDetails;
    }

    public Scan withResourceDetails(ResourceDetails resourceDetails) {
        this.setResourceDetails(resourceDetails);
        return this;
    }

    public void setScanResultDetails(ScanResultDetails scanResultDetails) {
        this.scanResultDetails = scanResultDetails;
    }

    public ScanResultDetails getScanResultDetails() {
        return this.scanResultDetails;
    }

    public Scan withScanResultDetails(ScanResultDetails scanResultDetails) {
        this.setScanResultDetails(scanResultDetails);
        return this;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public Scan withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setTotalBytes(Long totalBytes) {
        this.totalBytes = totalBytes;
    }

    public Long getTotalBytes() {
        return this.totalBytes;
    }

    public Scan withTotalBytes(Long totalBytes) {
        this.setTotalBytes(totalBytes);
        return this;
    }

    public void setFileCount(Long fileCount) {
        this.fileCount = fileCount;
    }

    public Long getFileCount() {
        return this.fileCount;
    }

    public Scan withFileCount(Long fileCount) {
        this.setFileCount(fileCount);
        return this;
    }

    public List<VolumeDetail> getAttachedVolumes() {
        return this.attachedVolumes;
    }

    public void setAttachedVolumes(Collection<VolumeDetail> attachedVolumes) {
        if (attachedVolumes == null) {
            this.attachedVolumes = null;
            return;
        }
        this.attachedVolumes = new ArrayList<VolumeDetail>(attachedVolumes);
    }

    public Scan withAttachedVolumes(VolumeDetail ... attachedVolumes) {
        if (this.attachedVolumes == null) {
            this.setAttachedVolumes(new ArrayList<VolumeDetail>(attachedVolumes.length));
        }
        for (VolumeDetail ele : attachedVolumes) {
            this.attachedVolumes.add(ele);
        }
        return this;
    }

    public Scan withAttachedVolumes(Collection<VolumeDetail> attachedVolumes) {
        this.setAttachedVolumes(attachedVolumes);
        return this;
    }

    public void setScanType(String scanType) {
        this.scanType = scanType;
    }

    public String getScanType() {
        return this.scanType;
    }

    public Scan withScanType(String scanType) {
        this.setScanType(scanType);
        return this;
    }

    public Scan withScanType(ScanType scanType) {
        this.scanType = scanType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDetectorId() != null) {
            sb.append("DetectorId: ").append(this.getDetectorId()).append(",");
        }
        if (this.getAdminDetectorId() != null) {
            sb.append("AdminDetectorId: ").append(this.getAdminDetectorId()).append(",");
        }
        if (this.getScanId() != null) {
            sb.append("ScanId: ").append(this.getScanId()).append(",");
        }
        if (this.getScanStatus() != null) {
            sb.append("ScanStatus: ").append(this.getScanStatus()).append(",");
        }
        if (this.getFailureReason() != null) {
            sb.append("FailureReason: ").append(this.getFailureReason()).append(",");
        }
        if (this.getScanStartTime() != null) {
            sb.append("ScanStartTime: ").append(this.getScanStartTime()).append(",");
        }
        if (this.getScanEndTime() != null) {
            sb.append("ScanEndTime: ").append(this.getScanEndTime()).append(",");
        }
        if (this.getTriggerDetails() != null) {
            sb.append("TriggerDetails: ").append(this.getTriggerDetails()).append(",");
        }
        if (this.getResourceDetails() != null) {
            sb.append("ResourceDetails: ").append(this.getResourceDetails()).append(",");
        }
        if (this.getScanResultDetails() != null) {
            sb.append("ScanResultDetails: ").append(this.getScanResultDetails()).append(",");
        }
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getTotalBytes() != null) {
            sb.append("TotalBytes: ").append(this.getTotalBytes()).append(",");
        }
        if (this.getFileCount() != null) {
            sb.append("FileCount: ").append(this.getFileCount()).append(",");
        }
        if (this.getAttachedVolumes() != null) {
            sb.append("AttachedVolumes: ").append(this.getAttachedVolumes()).append(",");
        }
        if (this.getScanType() != null) {
            sb.append("ScanType: ").append(this.getScanType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Scan)) {
            return false;
        }
        Scan other = (Scan)obj;
        if (other.getDetectorId() == null ^ this.getDetectorId() == null) {
            return false;
        }
        if (other.getDetectorId() != null && !other.getDetectorId().equals(this.getDetectorId())) {
            return false;
        }
        if (other.getAdminDetectorId() == null ^ this.getAdminDetectorId() == null) {
            return false;
        }
        if (other.getAdminDetectorId() != null && !other.getAdminDetectorId().equals(this.getAdminDetectorId())) {
            return false;
        }
        if (other.getScanId() == null ^ this.getScanId() == null) {
            return false;
        }
        if (other.getScanId() != null && !other.getScanId().equals(this.getScanId())) {
            return false;
        }
        if (other.getScanStatus() == null ^ this.getScanStatus() == null) {
            return false;
        }
        if (other.getScanStatus() != null && !other.getScanStatus().equals(this.getScanStatus())) {
            return false;
        }
        if (other.getFailureReason() == null ^ this.getFailureReason() == null) {
            return false;
        }
        if (other.getFailureReason() != null && !other.getFailureReason().equals(this.getFailureReason())) {
            return false;
        }
        if (other.getScanStartTime() == null ^ this.getScanStartTime() == null) {
            return false;
        }
        if (other.getScanStartTime() != null && !other.getScanStartTime().equals(this.getScanStartTime())) {
            return false;
        }
        if (other.getScanEndTime() == null ^ this.getScanEndTime() == null) {
            return false;
        }
        if (other.getScanEndTime() != null && !other.getScanEndTime().equals(this.getScanEndTime())) {
            return false;
        }
        if (other.getTriggerDetails() == null ^ this.getTriggerDetails() == null) {
            return false;
        }
        if (other.getTriggerDetails() != null && !other.getTriggerDetails().equals(this.getTriggerDetails())) {
            return false;
        }
        if (other.getResourceDetails() == null ^ this.getResourceDetails() == null) {
            return false;
        }
        if (other.getResourceDetails() != null && !other.getResourceDetails().equals(this.getResourceDetails())) {
            return false;
        }
        if (other.getScanResultDetails() == null ^ this.getScanResultDetails() == null) {
            return false;
        }
        if (other.getScanResultDetails() != null && !other.getScanResultDetails().equals(this.getScanResultDetails())) {
            return false;
        }
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getTotalBytes() == null ^ this.getTotalBytes() == null) {
            return false;
        }
        if (other.getTotalBytes() != null && !other.getTotalBytes().equals(this.getTotalBytes())) {
            return false;
        }
        if (other.getFileCount() == null ^ this.getFileCount() == null) {
            return false;
        }
        if (other.getFileCount() != null && !other.getFileCount().equals(this.getFileCount())) {
            return false;
        }
        if (other.getAttachedVolumes() == null ^ this.getAttachedVolumes() == null) {
            return false;
        }
        if (other.getAttachedVolumes() != null && !other.getAttachedVolumes().equals(this.getAttachedVolumes())) {
            return false;
        }
        if (other.getScanType() == null ^ this.getScanType() == null) {
            return false;
        }
        return other.getScanType() == null || other.getScanType().equals(this.getScanType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDetectorId() == null ? 0 : this.getDetectorId().hashCode());
        hashCode = 31 * hashCode + (this.getAdminDetectorId() == null ? 0 : this.getAdminDetectorId().hashCode());
        hashCode = 31 * hashCode + (this.getScanId() == null ? 0 : this.getScanId().hashCode());
        hashCode = 31 * hashCode + (this.getScanStatus() == null ? 0 : this.getScanStatus().hashCode());
        hashCode = 31 * hashCode + (this.getFailureReason() == null ? 0 : this.getFailureReason().hashCode());
        hashCode = 31 * hashCode + (this.getScanStartTime() == null ? 0 : this.getScanStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getScanEndTime() == null ? 0 : this.getScanEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getTriggerDetails() == null ? 0 : this.getTriggerDetails().hashCode());
        hashCode = 31 * hashCode + (this.getResourceDetails() == null ? 0 : this.getResourceDetails().hashCode());
        hashCode = 31 * hashCode + (this.getScanResultDetails() == null ? 0 : this.getScanResultDetails().hashCode());
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getTotalBytes() == null ? 0 : this.getTotalBytes().hashCode());
        hashCode = 31 * hashCode + (this.getFileCount() == null ? 0 : this.getFileCount().hashCode());
        hashCode = 31 * hashCode + (this.getAttachedVolumes() == null ? 0 : this.getAttachedVolumes().hashCode());
        hashCode = 31 * hashCode + (this.getScanType() == null ? 0 : this.getScanType().hashCode());
        return hashCode;
    }

    public Scan clone() {
        try {
            return (Scan)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScanMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

