/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.gamelift.model.ContainerDependency;
import com.amazonaws.services.gamelift.model.ContainerEnvironment;
import com.amazonaws.services.gamelift.model.ContainerHealthCheck;
import com.amazonaws.services.gamelift.model.ContainerMemoryLimits;
import com.amazonaws.services.gamelift.model.ContainerPortConfiguration;
import com.amazonaws.services.gamelift.model.transform.ContainerDefinitionInputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ContainerDefinitionInput
implements Serializable,
Cloneable,
StructuredPojo {
    private String containerName;
    private String imageUri;
    private ContainerMemoryLimits memoryLimits;
    private ContainerPortConfiguration portConfiguration;
    private Integer cpu;
    private ContainerHealthCheck healthCheck;
    private List<String> command;
    private Boolean essential;
    private List<String> entryPoint;
    private String workingDirectory;
    private List<ContainerEnvironment> environment;
    private List<ContainerDependency> dependsOn;

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public ContainerDefinitionInput withContainerName(String containerName) {
        this.setContainerName(containerName);
        return this;
    }

    public void setImageUri(String imageUri) {
        this.imageUri = imageUri;
    }

    public String getImageUri() {
        return this.imageUri;
    }

    public ContainerDefinitionInput withImageUri(String imageUri) {
        this.setImageUri(imageUri);
        return this;
    }

    public void setMemoryLimits(ContainerMemoryLimits memoryLimits) {
        this.memoryLimits = memoryLimits;
    }

    public ContainerMemoryLimits getMemoryLimits() {
        return this.memoryLimits;
    }

    public ContainerDefinitionInput withMemoryLimits(ContainerMemoryLimits memoryLimits) {
        this.setMemoryLimits(memoryLimits);
        return this;
    }

    public void setPortConfiguration(ContainerPortConfiguration portConfiguration) {
        this.portConfiguration = portConfiguration;
    }

    public ContainerPortConfiguration getPortConfiguration() {
        return this.portConfiguration;
    }

    public ContainerDefinitionInput withPortConfiguration(ContainerPortConfiguration portConfiguration) {
        this.setPortConfiguration(portConfiguration);
        return this;
    }

    public void setCpu(Integer cpu) {
        this.cpu = cpu;
    }

    public Integer getCpu() {
        return this.cpu;
    }

    public ContainerDefinitionInput withCpu(Integer cpu) {
        this.setCpu(cpu);
        return this;
    }

    public void setHealthCheck(ContainerHealthCheck healthCheck) {
        this.healthCheck = healthCheck;
    }

    public ContainerHealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    public ContainerDefinitionInput withHealthCheck(ContainerHealthCheck healthCheck) {
        this.setHealthCheck(healthCheck);
        return this;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public void setCommand(Collection<String> command) {
        if (command == null) {
            this.command = null;
            return;
        }
        this.command = new ArrayList<String>(command);
    }

    public ContainerDefinitionInput withCommand(String ... command) {
        if (this.command == null) {
            this.setCommand(new ArrayList<String>(command.length));
        }
        for (String ele : command) {
            this.command.add(ele);
        }
        return this;
    }

    public ContainerDefinitionInput withCommand(Collection<String> command) {
        this.setCommand(command);
        return this;
    }

    public void setEssential(Boolean essential) {
        this.essential = essential;
    }

    public Boolean getEssential() {
        return this.essential;
    }

    public ContainerDefinitionInput withEssential(Boolean essential) {
        this.setEssential(essential);
        return this;
    }

    public Boolean isEssential() {
        return this.essential;
    }

    public List<String> getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(Collection<String> entryPoint) {
        if (entryPoint == null) {
            this.entryPoint = null;
            return;
        }
        this.entryPoint = new ArrayList<String>(entryPoint);
    }

    public ContainerDefinitionInput withEntryPoint(String ... entryPoint) {
        if (this.entryPoint == null) {
            this.setEntryPoint(new ArrayList<String>(entryPoint.length));
        }
        for (String ele : entryPoint) {
            this.entryPoint.add(ele);
        }
        return this;
    }

    public ContainerDefinitionInput withEntryPoint(Collection<String> entryPoint) {
        this.setEntryPoint(entryPoint);
        return this;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public ContainerDefinitionInput withWorkingDirectory(String workingDirectory) {
        this.setWorkingDirectory(workingDirectory);
        return this;
    }

    public List<ContainerEnvironment> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Collection<ContainerEnvironment> environment) {
        if (environment == null) {
            this.environment = null;
            return;
        }
        this.environment = new ArrayList<ContainerEnvironment>(environment);
    }

    public ContainerDefinitionInput withEnvironment(ContainerEnvironment ... environment) {
        if (this.environment == null) {
            this.setEnvironment(new ArrayList<ContainerEnvironment>(environment.length));
        }
        for (ContainerEnvironment ele : environment) {
            this.environment.add(ele);
        }
        return this;
    }

    public ContainerDefinitionInput withEnvironment(Collection<ContainerEnvironment> environment) {
        this.setEnvironment(environment);
        return this;
    }

    public List<ContainerDependency> getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(Collection<ContainerDependency> dependsOn) {
        if (dependsOn == null) {
            this.dependsOn = null;
            return;
        }
        this.dependsOn = new ArrayList<ContainerDependency>(dependsOn);
    }

    public ContainerDefinitionInput withDependsOn(ContainerDependency ... dependsOn) {
        if (this.dependsOn == null) {
            this.setDependsOn(new ArrayList<ContainerDependency>(dependsOn.length));
        }
        for (ContainerDependency ele : dependsOn) {
            this.dependsOn.add(ele);
        }
        return this;
    }

    public ContainerDefinitionInput withDependsOn(Collection<ContainerDependency> dependsOn) {
        this.setDependsOn(dependsOn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContainerName() != null) {
            sb.append("ContainerName: ").append(this.getContainerName()).append(",");
        }
        if (this.getImageUri() != null) {
            sb.append("ImageUri: ").append(this.getImageUri()).append(",");
        }
        if (this.getMemoryLimits() != null) {
            sb.append("MemoryLimits: ").append(this.getMemoryLimits()).append(",");
        }
        if (this.getPortConfiguration() != null) {
            sb.append("PortConfiguration: ").append(this.getPortConfiguration()).append(",");
        }
        if (this.getCpu() != null) {
            sb.append("Cpu: ").append(this.getCpu()).append(",");
        }
        if (this.getHealthCheck() != null) {
            sb.append("HealthCheck: ").append(this.getHealthCheck()).append(",");
        }
        if (this.getCommand() != null) {
            sb.append("Command: ").append(this.getCommand()).append(",");
        }
        if (this.getEssential() != null) {
            sb.append("Essential: ").append(this.getEssential()).append(",");
        }
        if (this.getEntryPoint() != null) {
            sb.append("EntryPoint: ").append(this.getEntryPoint()).append(",");
        }
        if (this.getWorkingDirectory() != null) {
            sb.append("WorkingDirectory: ").append(this.getWorkingDirectory()).append(",");
        }
        if (this.getEnvironment() != null) {
            sb.append("Environment: ").append(this.getEnvironment()).append(",");
        }
        if (this.getDependsOn() != null) {
            sb.append("DependsOn: ").append(this.getDependsOn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerDefinitionInput)) {
            return false;
        }
        ContainerDefinitionInput other = (ContainerDefinitionInput)obj;
        if (other.getContainerName() == null ^ this.getContainerName() == null) {
            return false;
        }
        if (other.getContainerName() != null && !other.getContainerName().equals(this.getContainerName())) {
            return false;
        }
        if (other.getImageUri() == null ^ this.getImageUri() == null) {
            return false;
        }
        if (other.getImageUri() != null && !other.getImageUri().equals(this.getImageUri())) {
            return false;
        }
        if (other.getMemoryLimits() == null ^ this.getMemoryLimits() == null) {
            return false;
        }
        if (other.getMemoryLimits() != null && !other.getMemoryLimits().equals(this.getMemoryLimits())) {
            return false;
        }
        if (other.getPortConfiguration() == null ^ this.getPortConfiguration() == null) {
            return false;
        }
        if (other.getPortConfiguration() != null && !other.getPortConfiguration().equals(this.getPortConfiguration())) {
            return false;
        }
        if (other.getCpu() == null ^ this.getCpu() == null) {
            return false;
        }
        if (other.getCpu() != null && !other.getCpu().equals(this.getCpu())) {
            return false;
        }
        if (other.getHealthCheck() == null ^ this.getHealthCheck() == null) {
            return false;
        }
        if (other.getHealthCheck() != null && !other.getHealthCheck().equals(this.getHealthCheck())) {
            return false;
        }
        if (other.getCommand() == null ^ this.getCommand() == null) {
            return false;
        }
        if (other.getCommand() != null && !other.getCommand().equals(this.getCommand())) {
            return false;
        }
        if (other.getEssential() == null ^ this.getEssential() == null) {
            return false;
        }
        if (other.getEssential() != null && !other.getEssential().equals(this.getEssential())) {
            return false;
        }
        if (other.getEntryPoint() == null ^ this.getEntryPoint() == null) {
            return false;
        }
        if (other.getEntryPoint() != null && !other.getEntryPoint().equals(this.getEntryPoint())) {
            return false;
        }
        if (other.getWorkingDirectory() == null ^ this.getWorkingDirectory() == null) {
            return false;
        }
        if (other.getWorkingDirectory() != null && !other.getWorkingDirectory().equals(this.getWorkingDirectory())) {
            return false;
        }
        if (other.getEnvironment() == null ^ this.getEnvironment() == null) {
            return false;
        }
        if (other.getEnvironment() != null && !other.getEnvironment().equals(this.getEnvironment())) {
            return false;
        }
        if (other.getDependsOn() == null ^ this.getDependsOn() == null) {
            return false;
        }
        return other.getDependsOn() == null || other.getDependsOn().equals(this.getDependsOn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContainerName() == null ? 0 : this.getContainerName().hashCode());
        hashCode = 31 * hashCode + (this.getImageUri() == null ? 0 : this.getImageUri().hashCode());
        hashCode = 31 * hashCode + (this.getMemoryLimits() == null ? 0 : this.getMemoryLimits().hashCode());
        hashCode = 31 * hashCode + (this.getPortConfiguration() == null ? 0 : this.getPortConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getCpu() == null ? 0 : this.getCpu().hashCode());
        hashCode = 31 * hashCode + (this.getHealthCheck() == null ? 0 : this.getHealthCheck().hashCode());
        hashCode = 31 * hashCode + (this.getCommand() == null ? 0 : this.getCommand().hashCode());
        hashCode = 31 * hashCode + (this.getEssential() == null ? 0 : this.getEssential().hashCode());
        hashCode = 31 * hashCode + (this.getEntryPoint() == null ? 0 : this.getEntryPoint().hashCode());
        hashCode = 31 * hashCode + (this.getWorkingDirectory() == null ? 0 : this.getWorkingDirectory().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironment() == null ? 0 : this.getEnvironment().hashCode());
        hashCode = 31 * hashCode + (this.getDependsOn() == null ? 0 : this.getDependsOn().hashCode());
        return hashCode;
    }

    public ContainerDefinitionInput clone() {
        try {
            return (ContainerDefinitionInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContainerDefinitionInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

