/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model;

import com.amazonaws.services.elasticloadbalancingv2.model.Cipher;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SslPolicy
implements Serializable,
Cloneable {
    private List<String> sslProtocols;
    private List<Cipher> ciphers;
    private String name;

    public List<String> getSslProtocols() {
        return this.sslProtocols;
    }

    public void setSslProtocols(Collection<String> sslProtocols) {
        if (sslProtocols == null) {
            this.sslProtocols = null;
            return;
        }
        this.sslProtocols = new ArrayList<String>(sslProtocols);
    }

    public SslPolicy withSslProtocols(String ... sslProtocols) {
        if (this.sslProtocols == null) {
            this.setSslProtocols(new ArrayList<String>(sslProtocols.length));
        }
        for (String ele : sslProtocols) {
            this.sslProtocols.add(ele);
        }
        return this;
    }

    public SslPolicy withSslProtocols(Collection<String> sslProtocols) {
        this.setSslProtocols(sslProtocols);
        return this;
    }

    public List<Cipher> getCiphers() {
        return this.ciphers;
    }

    public void setCiphers(Collection<Cipher> ciphers) {
        if (ciphers == null) {
            this.ciphers = null;
            return;
        }
        this.ciphers = new ArrayList<Cipher>(ciphers);
    }

    public SslPolicy withCiphers(Cipher ... ciphers) {
        if (this.ciphers == null) {
            this.setCiphers(new ArrayList<Cipher>(ciphers.length));
        }
        for (Cipher ele : ciphers) {
            this.ciphers.add(ele);
        }
        return this;
    }

    public SslPolicy withCiphers(Collection<Cipher> ciphers) {
        this.setCiphers(ciphers);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public SslPolicy withName(String name) {
        this.setName(name);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSslProtocols() != null) {
            sb.append("SslProtocols: " + this.getSslProtocols() + ",");
        }
        if (this.getCiphers() != null) {
            sb.append("Ciphers: " + this.getCiphers() + ",");
        }
        if (this.getName() != null) {
            sb.append("Name: " + this.getName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SslPolicy)) {
            return false;
        }
        SslPolicy other = (SslPolicy)obj;
        if (other.getSslProtocols() == null ^ this.getSslProtocols() == null) {
            return false;
        }
        if (other.getSslProtocols() != null && !other.getSslProtocols().equals(this.getSslProtocols())) {
            return false;
        }
        if (other.getCiphers() == null ^ this.getCiphers() == null) {
            return false;
        }
        if (other.getCiphers() != null && !other.getCiphers().equals(this.getCiphers())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        return other.getName() == null || other.getName().equals(this.getName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSslProtocols() == null ? 0 : this.getSslProtocols().hashCode());
        hashCode = 31 * hashCode + (this.getCiphers() == null ? 0 : this.getCiphers().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        return hashCode;
    }

    public SslPolicy clone() {
        try {
            return (SslPolicy)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

