/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DetachLoadBalancerFromSubnetsRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String loadBalancerName;
    private ListWithAutoConstructFlag<String> subnets;

    public String getLoadBalancerName() {
        return this.loadBalancerName;
    }

    public void setLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
    }

    public DetachLoadBalancerFromSubnetsRequest withLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
        return this;
    }

    public List<String> getSubnets() {
        if (this.subnets == null) {
            this.subnets = new ListWithAutoConstructFlag();
            this.subnets.setAutoConstruct(true);
        }
        return this.subnets;
    }

    public void setSubnets(Collection<String> subnets) {
        if (subnets == null) {
            this.subnets = null;
            return;
        }
        ListWithAutoConstructFlag subnetsCopy = new ListWithAutoConstructFlag(subnets.size());
        subnetsCopy.addAll(subnets);
        this.subnets = subnetsCopy;
    }

    public DetachLoadBalancerFromSubnetsRequest withSubnets(String ... subnets) {
        if (this.getSubnets() == null) {
            this.setSubnets(new ArrayList<String>(subnets.length));
        }
        for (String value : subnets) {
            this.getSubnets().add(value);
        }
        return this;
    }

    public DetachLoadBalancerFromSubnetsRequest withSubnets(Collection<String> subnets) {
        if (subnets == null) {
            this.subnets = null;
        } else {
            ListWithAutoConstructFlag subnetsCopy = new ListWithAutoConstructFlag(subnets.size());
            subnetsCopy.addAll(subnets);
            this.subnets = subnetsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLoadBalancerName() != null) {
            sb.append("LoadBalancerName: " + this.getLoadBalancerName() + ",");
        }
        if (this.getSubnets() != null) {
            sb.append("Subnets: " + this.getSubnets());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLoadBalancerName() == null ? 0 : this.getLoadBalancerName().hashCode());
        hashCode = 31 * hashCode + (this.getSubnets() == null ? 0 : this.getSubnets().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachLoadBalancerFromSubnetsRequest)) {
            return false;
        }
        DetachLoadBalancerFromSubnetsRequest other = (DetachLoadBalancerFromSubnetsRequest)obj;
        if (other.getLoadBalancerName() == null ^ this.getLoadBalancerName() == null) {
            return false;
        }
        if (other.getLoadBalancerName() != null && !other.getLoadBalancerName().equals(this.getLoadBalancerName())) {
            return false;
        }
        if (other.getSubnets() == null ^ this.getSubnets() == null) {
            return false;
        }
        return other.getSubnets() == null || other.getSubnets().equals(this.getSubnets());
    }
}

