/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.AutomaticFailoverStatus;
import com.amazonaws.services.elasticache.model.ClusterMode;
import com.amazonaws.services.elasticache.model.DataTieringStatus;
import com.amazonaws.services.elasticache.model.Endpoint;
import com.amazonaws.services.elasticache.model.GlobalReplicationGroupInfo;
import com.amazonaws.services.elasticache.model.IpDiscovery;
import com.amazonaws.services.elasticache.model.LogDeliveryConfiguration;
import com.amazonaws.services.elasticache.model.MultiAZStatus;
import com.amazonaws.services.elasticache.model.NetworkType;
import com.amazonaws.services.elasticache.model.NodeGroup;
import com.amazonaws.services.elasticache.model.ReplicationGroupPendingModifiedValues;
import com.amazonaws.services.elasticache.model.TransitEncryptionMode;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ReplicationGroup
implements Serializable,
Cloneable {
    private String replicationGroupId;
    private String description;
    private GlobalReplicationGroupInfo globalReplicationGroupInfo;
    private String status;
    private ReplicationGroupPendingModifiedValues pendingModifiedValues;
    private SdkInternalList<String> memberClusters;
    private SdkInternalList<NodeGroup> nodeGroups;
    private String snapshottingClusterId;
    private String automaticFailover;
    private String multiAZ;
    private Endpoint configurationEndpoint;
    private Integer snapshotRetentionLimit;
    private String snapshotWindow;
    private Boolean clusterEnabled;
    private String cacheNodeType;
    private Boolean authTokenEnabled;
    private Date authTokenLastModifiedDate;
    private Boolean transitEncryptionEnabled;
    private Boolean atRestEncryptionEnabled;
    private SdkInternalList<String> memberClustersOutpostArns;
    private String kmsKeyId;
    private String aRN;
    private SdkInternalList<String> userGroupIds;
    private SdkInternalList<LogDeliveryConfiguration> logDeliveryConfigurations;
    private Date replicationGroupCreateTime;
    private String dataTiering;
    private Boolean autoMinorVersionUpgrade;
    private String networkType;
    private String ipDiscovery;
    private String transitEncryptionMode;
    private String clusterMode;

    public void setReplicationGroupId(String replicationGroupId) {
        this.replicationGroupId = replicationGroupId;
    }

    public String getReplicationGroupId() {
        return this.replicationGroupId;
    }

    public ReplicationGroup withReplicationGroupId(String replicationGroupId) {
        this.setReplicationGroupId(replicationGroupId);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ReplicationGroup withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setGlobalReplicationGroupInfo(GlobalReplicationGroupInfo globalReplicationGroupInfo) {
        this.globalReplicationGroupInfo = globalReplicationGroupInfo;
    }

    public GlobalReplicationGroupInfo getGlobalReplicationGroupInfo() {
        return this.globalReplicationGroupInfo;
    }

    public ReplicationGroup withGlobalReplicationGroupInfo(GlobalReplicationGroupInfo globalReplicationGroupInfo) {
        this.setGlobalReplicationGroupInfo(globalReplicationGroupInfo);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public ReplicationGroup withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setPendingModifiedValues(ReplicationGroupPendingModifiedValues pendingModifiedValues) {
        this.pendingModifiedValues = pendingModifiedValues;
    }

    public ReplicationGroupPendingModifiedValues getPendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public ReplicationGroup withPendingModifiedValues(ReplicationGroupPendingModifiedValues pendingModifiedValues) {
        this.setPendingModifiedValues(pendingModifiedValues);
        return this;
    }

    public List<String> getMemberClusters() {
        if (this.memberClusters == null) {
            this.memberClusters = new SdkInternalList();
        }
        return this.memberClusters;
    }

    public void setMemberClusters(Collection<String> memberClusters) {
        if (memberClusters == null) {
            this.memberClusters = null;
            return;
        }
        this.memberClusters = new SdkInternalList(memberClusters);
    }

    public ReplicationGroup withMemberClusters(String ... memberClusters) {
        if (this.memberClusters == null) {
            this.setMemberClusters((Collection<String>)new SdkInternalList(memberClusters.length));
        }
        for (String ele : memberClusters) {
            this.memberClusters.add((Object)ele);
        }
        return this;
    }

    public ReplicationGroup withMemberClusters(Collection<String> memberClusters) {
        this.setMemberClusters(memberClusters);
        return this;
    }

    public List<NodeGroup> getNodeGroups() {
        if (this.nodeGroups == null) {
            this.nodeGroups = new SdkInternalList();
        }
        return this.nodeGroups;
    }

    public void setNodeGroups(Collection<NodeGroup> nodeGroups) {
        if (nodeGroups == null) {
            this.nodeGroups = null;
            return;
        }
        this.nodeGroups = new SdkInternalList(nodeGroups);
    }

    public ReplicationGroup withNodeGroups(NodeGroup ... nodeGroups) {
        if (this.nodeGroups == null) {
            this.setNodeGroups((Collection<NodeGroup>)new SdkInternalList(nodeGroups.length));
        }
        for (NodeGroup ele : nodeGroups) {
            this.nodeGroups.add((Object)ele);
        }
        return this;
    }

    public ReplicationGroup withNodeGroups(Collection<NodeGroup> nodeGroups) {
        this.setNodeGroups(nodeGroups);
        return this;
    }

    public void setSnapshottingClusterId(String snapshottingClusterId) {
        this.snapshottingClusterId = snapshottingClusterId;
    }

    public String getSnapshottingClusterId() {
        return this.snapshottingClusterId;
    }

    public ReplicationGroup withSnapshottingClusterId(String snapshottingClusterId) {
        this.setSnapshottingClusterId(snapshottingClusterId);
        return this;
    }

    public void setAutomaticFailover(String automaticFailover) {
        this.automaticFailover = automaticFailover;
    }

    public String getAutomaticFailover() {
        return this.automaticFailover;
    }

    public ReplicationGroup withAutomaticFailover(String automaticFailover) {
        this.setAutomaticFailover(automaticFailover);
        return this;
    }

    public void setAutomaticFailover(AutomaticFailoverStatus automaticFailover) {
        this.withAutomaticFailover(automaticFailover);
    }

    public ReplicationGroup withAutomaticFailover(AutomaticFailoverStatus automaticFailover) {
        this.automaticFailover = automaticFailover.toString();
        return this;
    }

    public void setMultiAZ(String multiAZ) {
        this.multiAZ = multiAZ;
    }

    public String getMultiAZ() {
        return this.multiAZ;
    }

    public ReplicationGroup withMultiAZ(String multiAZ) {
        this.setMultiAZ(multiAZ);
        return this;
    }

    public void setMultiAZ(MultiAZStatus multiAZ) {
        this.withMultiAZ(multiAZ);
    }

    public ReplicationGroup withMultiAZ(MultiAZStatus multiAZ) {
        this.multiAZ = multiAZ.toString();
        return this;
    }

    public void setConfigurationEndpoint(Endpoint configurationEndpoint) {
        this.configurationEndpoint = configurationEndpoint;
    }

    public Endpoint getConfigurationEndpoint() {
        return this.configurationEndpoint;
    }

    public ReplicationGroup withConfigurationEndpoint(Endpoint configurationEndpoint) {
        this.setConfigurationEndpoint(configurationEndpoint);
        return this;
    }

    public void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
        this.snapshotRetentionLimit = snapshotRetentionLimit;
    }

    public Integer getSnapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public ReplicationGroup withSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
        this.setSnapshotRetentionLimit(snapshotRetentionLimit);
        return this;
    }

    public void setSnapshotWindow(String snapshotWindow) {
        this.snapshotWindow = snapshotWindow;
    }

    public String getSnapshotWindow() {
        return this.snapshotWindow;
    }

    public ReplicationGroup withSnapshotWindow(String snapshotWindow) {
        this.setSnapshotWindow(snapshotWindow);
        return this;
    }

    public void setClusterEnabled(Boolean clusterEnabled) {
        this.clusterEnabled = clusterEnabled;
    }

    public Boolean getClusterEnabled() {
        return this.clusterEnabled;
    }

    public ReplicationGroup withClusterEnabled(Boolean clusterEnabled) {
        this.setClusterEnabled(clusterEnabled);
        return this;
    }

    public Boolean isClusterEnabled() {
        return this.clusterEnabled;
    }

    public void setCacheNodeType(String cacheNodeType) {
        this.cacheNodeType = cacheNodeType;
    }

    public String getCacheNodeType() {
        return this.cacheNodeType;
    }

    public ReplicationGroup withCacheNodeType(String cacheNodeType) {
        this.setCacheNodeType(cacheNodeType);
        return this;
    }

    public void setAuthTokenEnabled(Boolean authTokenEnabled) {
        this.authTokenEnabled = authTokenEnabled;
    }

    public Boolean getAuthTokenEnabled() {
        return this.authTokenEnabled;
    }

    public ReplicationGroup withAuthTokenEnabled(Boolean authTokenEnabled) {
        this.setAuthTokenEnabled(authTokenEnabled);
        return this;
    }

    public Boolean isAuthTokenEnabled() {
        return this.authTokenEnabled;
    }

    public void setAuthTokenLastModifiedDate(Date authTokenLastModifiedDate) {
        this.authTokenLastModifiedDate = authTokenLastModifiedDate;
    }

    public Date getAuthTokenLastModifiedDate() {
        return this.authTokenLastModifiedDate;
    }

    public ReplicationGroup withAuthTokenLastModifiedDate(Date authTokenLastModifiedDate) {
        this.setAuthTokenLastModifiedDate(authTokenLastModifiedDate);
        return this;
    }

    public void setTransitEncryptionEnabled(Boolean transitEncryptionEnabled) {
        this.transitEncryptionEnabled = transitEncryptionEnabled;
    }

    public Boolean getTransitEncryptionEnabled() {
        return this.transitEncryptionEnabled;
    }

    public ReplicationGroup withTransitEncryptionEnabled(Boolean transitEncryptionEnabled) {
        this.setTransitEncryptionEnabled(transitEncryptionEnabled);
        return this;
    }

    public Boolean isTransitEncryptionEnabled() {
        return this.transitEncryptionEnabled;
    }

    public void setAtRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
        this.atRestEncryptionEnabled = atRestEncryptionEnabled;
    }

    public Boolean getAtRestEncryptionEnabled() {
        return this.atRestEncryptionEnabled;
    }

    public ReplicationGroup withAtRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
        this.setAtRestEncryptionEnabled(atRestEncryptionEnabled);
        return this;
    }

    public Boolean isAtRestEncryptionEnabled() {
        return this.atRestEncryptionEnabled;
    }

    public List<String> getMemberClustersOutpostArns() {
        if (this.memberClustersOutpostArns == null) {
            this.memberClustersOutpostArns = new SdkInternalList();
        }
        return this.memberClustersOutpostArns;
    }

    public void setMemberClustersOutpostArns(Collection<String> memberClustersOutpostArns) {
        if (memberClustersOutpostArns == null) {
            this.memberClustersOutpostArns = null;
            return;
        }
        this.memberClustersOutpostArns = new SdkInternalList(memberClustersOutpostArns);
    }

    public ReplicationGroup withMemberClustersOutpostArns(String ... memberClustersOutpostArns) {
        if (this.memberClustersOutpostArns == null) {
            this.setMemberClustersOutpostArns((Collection<String>)new SdkInternalList(memberClustersOutpostArns.length));
        }
        for (String ele : memberClustersOutpostArns) {
            this.memberClustersOutpostArns.add((Object)ele);
        }
        return this;
    }

    public ReplicationGroup withMemberClustersOutpostArns(Collection<String> memberClustersOutpostArns) {
        this.setMemberClustersOutpostArns(memberClustersOutpostArns);
        return this;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public ReplicationGroup withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public void setARN(String aRN) {
        this.aRN = aRN;
    }

    public String getARN() {
        return this.aRN;
    }

    public ReplicationGroup withARN(String aRN) {
        this.setARN(aRN);
        return this;
    }

    public List<String> getUserGroupIds() {
        if (this.userGroupIds == null) {
            this.userGroupIds = new SdkInternalList();
        }
        return this.userGroupIds;
    }

    public void setUserGroupIds(Collection<String> userGroupIds) {
        if (userGroupIds == null) {
            this.userGroupIds = null;
            return;
        }
        this.userGroupIds = new SdkInternalList(userGroupIds);
    }

    public ReplicationGroup withUserGroupIds(String ... userGroupIds) {
        if (this.userGroupIds == null) {
            this.setUserGroupIds((Collection<String>)new SdkInternalList(userGroupIds.length));
        }
        for (String ele : userGroupIds) {
            this.userGroupIds.add((Object)ele);
        }
        return this;
    }

    public ReplicationGroup withUserGroupIds(Collection<String> userGroupIds) {
        this.setUserGroupIds(userGroupIds);
        return this;
    }

    public List<LogDeliveryConfiguration> getLogDeliveryConfigurations() {
        if (this.logDeliveryConfigurations == null) {
            this.logDeliveryConfigurations = new SdkInternalList();
        }
        return this.logDeliveryConfigurations;
    }

    public void setLogDeliveryConfigurations(Collection<LogDeliveryConfiguration> logDeliveryConfigurations) {
        if (logDeliveryConfigurations == null) {
            this.logDeliveryConfigurations = null;
            return;
        }
        this.logDeliveryConfigurations = new SdkInternalList(logDeliveryConfigurations);
    }

    public ReplicationGroup withLogDeliveryConfigurations(LogDeliveryConfiguration ... logDeliveryConfigurations) {
        if (this.logDeliveryConfigurations == null) {
            this.setLogDeliveryConfigurations((Collection<LogDeliveryConfiguration>)new SdkInternalList(logDeliveryConfigurations.length));
        }
        for (LogDeliveryConfiguration ele : logDeliveryConfigurations) {
            this.logDeliveryConfigurations.add((Object)ele);
        }
        return this;
    }

    public ReplicationGroup withLogDeliveryConfigurations(Collection<LogDeliveryConfiguration> logDeliveryConfigurations) {
        this.setLogDeliveryConfigurations(logDeliveryConfigurations);
        return this;
    }

    public void setReplicationGroupCreateTime(Date replicationGroupCreateTime) {
        this.replicationGroupCreateTime = replicationGroupCreateTime;
    }

    public Date getReplicationGroupCreateTime() {
        return this.replicationGroupCreateTime;
    }

    public ReplicationGroup withReplicationGroupCreateTime(Date replicationGroupCreateTime) {
        this.setReplicationGroupCreateTime(replicationGroupCreateTime);
        return this;
    }

    public void setDataTiering(String dataTiering) {
        this.dataTiering = dataTiering;
    }

    public String getDataTiering() {
        return this.dataTiering;
    }

    public ReplicationGroup withDataTiering(String dataTiering) {
        this.setDataTiering(dataTiering);
        return this;
    }

    public void setDataTiering(DataTieringStatus dataTiering) {
        this.withDataTiering(dataTiering);
    }

    public ReplicationGroup withDataTiering(DataTieringStatus dataTiering) {
        this.dataTiering = dataTiering.toString();
        return this;
    }

    public void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
    }

    public Boolean getAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public ReplicationGroup withAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.setAutoMinorVersionUpgrade(autoMinorVersionUpgrade);
        return this;
    }

    public Boolean isAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public void setNetworkType(String networkType) {
        this.networkType = networkType;
    }

    public String getNetworkType() {
        return this.networkType;
    }

    public ReplicationGroup withNetworkType(String networkType) {
        this.setNetworkType(networkType);
        return this;
    }

    public void setNetworkType(NetworkType networkType) {
        this.withNetworkType(networkType);
    }

    public ReplicationGroup withNetworkType(NetworkType networkType) {
        this.networkType = networkType.toString();
        return this;
    }

    public void setIpDiscovery(String ipDiscovery) {
        this.ipDiscovery = ipDiscovery;
    }

    public String getIpDiscovery() {
        return this.ipDiscovery;
    }

    public ReplicationGroup withIpDiscovery(String ipDiscovery) {
        this.setIpDiscovery(ipDiscovery);
        return this;
    }

    public void setIpDiscovery(IpDiscovery ipDiscovery) {
        this.withIpDiscovery(ipDiscovery);
    }

    public ReplicationGroup withIpDiscovery(IpDiscovery ipDiscovery) {
        this.ipDiscovery = ipDiscovery.toString();
        return this;
    }

    public void setTransitEncryptionMode(String transitEncryptionMode) {
        this.transitEncryptionMode = transitEncryptionMode;
    }

    public String getTransitEncryptionMode() {
        return this.transitEncryptionMode;
    }

    public ReplicationGroup withTransitEncryptionMode(String transitEncryptionMode) {
        this.setTransitEncryptionMode(transitEncryptionMode);
        return this;
    }

    public void setTransitEncryptionMode(TransitEncryptionMode transitEncryptionMode) {
        this.withTransitEncryptionMode(transitEncryptionMode);
    }

    public ReplicationGroup withTransitEncryptionMode(TransitEncryptionMode transitEncryptionMode) {
        this.transitEncryptionMode = transitEncryptionMode.toString();
        return this;
    }

    public void setClusterMode(String clusterMode) {
        this.clusterMode = clusterMode;
    }

    public String getClusterMode() {
        return this.clusterMode;
    }

    public ReplicationGroup withClusterMode(String clusterMode) {
        this.setClusterMode(clusterMode);
        return this;
    }

    public void setClusterMode(ClusterMode clusterMode) {
        this.withClusterMode(clusterMode);
    }

    public ReplicationGroup withClusterMode(ClusterMode clusterMode) {
        this.clusterMode = clusterMode.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReplicationGroupId() != null) {
            sb.append("ReplicationGroupId: ").append(this.getReplicationGroupId()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getGlobalReplicationGroupInfo() != null) {
            sb.append("GlobalReplicationGroupInfo: ").append(this.getGlobalReplicationGroupInfo()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getPendingModifiedValues() != null) {
            sb.append("PendingModifiedValues: ").append(this.getPendingModifiedValues()).append(",");
        }
        if (this.getMemberClusters() != null) {
            sb.append("MemberClusters: ").append(this.getMemberClusters()).append(",");
        }
        if (this.getNodeGroups() != null) {
            sb.append("NodeGroups: ").append(this.getNodeGroups()).append(",");
        }
        if (this.getSnapshottingClusterId() != null) {
            sb.append("SnapshottingClusterId: ").append(this.getSnapshottingClusterId()).append(",");
        }
        if (this.getAutomaticFailover() != null) {
            sb.append("AutomaticFailover: ").append(this.getAutomaticFailover()).append(",");
        }
        if (this.getMultiAZ() != null) {
            sb.append("MultiAZ: ").append(this.getMultiAZ()).append(",");
        }
        if (this.getConfigurationEndpoint() != null) {
            sb.append("ConfigurationEndpoint: ").append(this.getConfigurationEndpoint()).append(",");
        }
        if (this.getSnapshotRetentionLimit() != null) {
            sb.append("SnapshotRetentionLimit: ").append(this.getSnapshotRetentionLimit()).append(",");
        }
        if (this.getSnapshotWindow() != null) {
            sb.append("SnapshotWindow: ").append(this.getSnapshotWindow()).append(",");
        }
        if (this.getClusterEnabled() != null) {
            sb.append("ClusterEnabled: ").append(this.getClusterEnabled()).append(",");
        }
        if (this.getCacheNodeType() != null) {
            sb.append("CacheNodeType: ").append(this.getCacheNodeType()).append(",");
        }
        if (this.getAuthTokenEnabled() != null) {
            sb.append("AuthTokenEnabled: ").append(this.getAuthTokenEnabled()).append(",");
        }
        if (this.getAuthTokenLastModifiedDate() != null) {
            sb.append("AuthTokenLastModifiedDate: ").append(this.getAuthTokenLastModifiedDate()).append(",");
        }
        if (this.getTransitEncryptionEnabled() != null) {
            sb.append("TransitEncryptionEnabled: ").append(this.getTransitEncryptionEnabled()).append(",");
        }
        if (this.getAtRestEncryptionEnabled() != null) {
            sb.append("AtRestEncryptionEnabled: ").append(this.getAtRestEncryptionEnabled()).append(",");
        }
        if (this.getMemberClustersOutpostArns() != null) {
            sb.append("MemberClustersOutpostArns: ").append(this.getMemberClustersOutpostArns()).append(",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId()).append(",");
        }
        if (this.getARN() != null) {
            sb.append("ARN: ").append(this.getARN()).append(",");
        }
        if (this.getUserGroupIds() != null) {
            sb.append("UserGroupIds: ").append(this.getUserGroupIds()).append(",");
        }
        if (this.getLogDeliveryConfigurations() != null) {
            sb.append("LogDeliveryConfigurations: ").append(this.getLogDeliveryConfigurations()).append(",");
        }
        if (this.getReplicationGroupCreateTime() != null) {
            sb.append("ReplicationGroupCreateTime: ").append(this.getReplicationGroupCreateTime()).append(",");
        }
        if (this.getDataTiering() != null) {
            sb.append("DataTiering: ").append(this.getDataTiering()).append(",");
        }
        if (this.getAutoMinorVersionUpgrade() != null) {
            sb.append("AutoMinorVersionUpgrade: ").append(this.getAutoMinorVersionUpgrade()).append(",");
        }
        if (this.getNetworkType() != null) {
            sb.append("NetworkType: ").append(this.getNetworkType()).append(",");
        }
        if (this.getIpDiscovery() != null) {
            sb.append("IpDiscovery: ").append(this.getIpDiscovery()).append(",");
        }
        if (this.getTransitEncryptionMode() != null) {
            sb.append("TransitEncryptionMode: ").append(this.getTransitEncryptionMode()).append(",");
        }
        if (this.getClusterMode() != null) {
            sb.append("ClusterMode: ").append(this.getClusterMode());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationGroup)) {
            return false;
        }
        ReplicationGroup other = (ReplicationGroup)obj;
        if (other.getReplicationGroupId() == null ^ this.getReplicationGroupId() == null) {
            return false;
        }
        if (other.getReplicationGroupId() != null && !other.getReplicationGroupId().equals(this.getReplicationGroupId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getGlobalReplicationGroupInfo() == null ^ this.getGlobalReplicationGroupInfo() == null) {
            return false;
        }
        if (other.getGlobalReplicationGroupInfo() != null && !other.getGlobalReplicationGroupInfo().equals(this.getGlobalReplicationGroupInfo())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getPendingModifiedValues() == null ^ this.getPendingModifiedValues() == null) {
            return false;
        }
        if (other.getPendingModifiedValues() != null && !other.getPendingModifiedValues().equals(this.getPendingModifiedValues())) {
            return false;
        }
        if (other.getMemberClusters() == null ^ this.getMemberClusters() == null) {
            return false;
        }
        if (other.getMemberClusters() != null && !other.getMemberClusters().equals(this.getMemberClusters())) {
            return false;
        }
        if (other.getNodeGroups() == null ^ this.getNodeGroups() == null) {
            return false;
        }
        if (other.getNodeGroups() != null && !other.getNodeGroups().equals(this.getNodeGroups())) {
            return false;
        }
        if (other.getSnapshottingClusterId() == null ^ this.getSnapshottingClusterId() == null) {
            return false;
        }
        if (other.getSnapshottingClusterId() != null && !other.getSnapshottingClusterId().equals(this.getSnapshottingClusterId())) {
            return false;
        }
        if (other.getAutomaticFailover() == null ^ this.getAutomaticFailover() == null) {
            return false;
        }
        if (other.getAutomaticFailover() != null && !other.getAutomaticFailover().equals(this.getAutomaticFailover())) {
            return false;
        }
        if (other.getMultiAZ() == null ^ this.getMultiAZ() == null) {
            return false;
        }
        if (other.getMultiAZ() != null && !other.getMultiAZ().equals(this.getMultiAZ())) {
            return false;
        }
        if (other.getConfigurationEndpoint() == null ^ this.getConfigurationEndpoint() == null) {
            return false;
        }
        if (other.getConfigurationEndpoint() != null && !other.getConfigurationEndpoint().equals(this.getConfigurationEndpoint())) {
            return false;
        }
        if (other.getSnapshotRetentionLimit() == null ^ this.getSnapshotRetentionLimit() == null) {
            return false;
        }
        if (other.getSnapshotRetentionLimit() != null && !other.getSnapshotRetentionLimit().equals(this.getSnapshotRetentionLimit())) {
            return false;
        }
        if (other.getSnapshotWindow() == null ^ this.getSnapshotWindow() == null) {
            return false;
        }
        if (other.getSnapshotWindow() != null && !other.getSnapshotWindow().equals(this.getSnapshotWindow())) {
            return false;
        }
        if (other.getClusterEnabled() == null ^ this.getClusterEnabled() == null) {
            return false;
        }
        if (other.getClusterEnabled() != null && !other.getClusterEnabled().equals(this.getClusterEnabled())) {
            return false;
        }
        if (other.getCacheNodeType() == null ^ this.getCacheNodeType() == null) {
            return false;
        }
        if (other.getCacheNodeType() != null && !other.getCacheNodeType().equals(this.getCacheNodeType())) {
            return false;
        }
        if (other.getAuthTokenEnabled() == null ^ this.getAuthTokenEnabled() == null) {
            return false;
        }
        if (other.getAuthTokenEnabled() != null && !other.getAuthTokenEnabled().equals(this.getAuthTokenEnabled())) {
            return false;
        }
        if (other.getAuthTokenLastModifiedDate() == null ^ this.getAuthTokenLastModifiedDate() == null) {
            return false;
        }
        if (other.getAuthTokenLastModifiedDate() != null && !other.getAuthTokenLastModifiedDate().equals(this.getAuthTokenLastModifiedDate())) {
            return false;
        }
        if (other.getTransitEncryptionEnabled() == null ^ this.getTransitEncryptionEnabled() == null) {
            return false;
        }
        if (other.getTransitEncryptionEnabled() != null && !other.getTransitEncryptionEnabled().equals(this.getTransitEncryptionEnabled())) {
            return false;
        }
        if (other.getAtRestEncryptionEnabled() == null ^ this.getAtRestEncryptionEnabled() == null) {
            return false;
        }
        if (other.getAtRestEncryptionEnabled() != null && !other.getAtRestEncryptionEnabled().equals(this.getAtRestEncryptionEnabled())) {
            return false;
        }
        if (other.getMemberClustersOutpostArns() == null ^ this.getMemberClustersOutpostArns() == null) {
            return false;
        }
        if (other.getMemberClustersOutpostArns() != null && !other.getMemberClustersOutpostArns().equals(this.getMemberClustersOutpostArns())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        if (other.getKmsKeyId() != null && !other.getKmsKeyId().equals(this.getKmsKeyId())) {
            return false;
        }
        if (other.getARN() == null ^ this.getARN() == null) {
            return false;
        }
        if (other.getARN() != null && !other.getARN().equals(this.getARN())) {
            return false;
        }
        if (other.getUserGroupIds() == null ^ this.getUserGroupIds() == null) {
            return false;
        }
        if (other.getUserGroupIds() != null && !other.getUserGroupIds().equals(this.getUserGroupIds())) {
            return false;
        }
        if (other.getLogDeliveryConfigurations() == null ^ this.getLogDeliveryConfigurations() == null) {
            return false;
        }
        if (other.getLogDeliveryConfigurations() != null && !other.getLogDeliveryConfigurations().equals(this.getLogDeliveryConfigurations())) {
            return false;
        }
        if (other.getReplicationGroupCreateTime() == null ^ this.getReplicationGroupCreateTime() == null) {
            return false;
        }
        if (other.getReplicationGroupCreateTime() != null && !other.getReplicationGroupCreateTime().equals(this.getReplicationGroupCreateTime())) {
            return false;
        }
        if (other.getDataTiering() == null ^ this.getDataTiering() == null) {
            return false;
        }
        if (other.getDataTiering() != null && !other.getDataTiering().equals(this.getDataTiering())) {
            return false;
        }
        if (other.getAutoMinorVersionUpgrade() == null ^ this.getAutoMinorVersionUpgrade() == null) {
            return false;
        }
        if (other.getAutoMinorVersionUpgrade() != null && !other.getAutoMinorVersionUpgrade().equals(this.getAutoMinorVersionUpgrade())) {
            return false;
        }
        if (other.getNetworkType() == null ^ this.getNetworkType() == null) {
            return false;
        }
        if (other.getNetworkType() != null && !other.getNetworkType().equals(this.getNetworkType())) {
            return false;
        }
        if (other.getIpDiscovery() == null ^ this.getIpDiscovery() == null) {
            return false;
        }
        if (other.getIpDiscovery() != null && !other.getIpDiscovery().equals(this.getIpDiscovery())) {
            return false;
        }
        if (other.getTransitEncryptionMode() == null ^ this.getTransitEncryptionMode() == null) {
            return false;
        }
        if (other.getTransitEncryptionMode() != null && !other.getTransitEncryptionMode().equals(this.getTransitEncryptionMode())) {
            return false;
        }
        if (other.getClusterMode() == null ^ this.getClusterMode() == null) {
            return false;
        }
        return other.getClusterMode() == null || other.getClusterMode().equals(this.getClusterMode());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReplicationGroupId() == null ? 0 : this.getReplicationGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getGlobalReplicationGroupInfo() == null ? 0 : this.getGlobalReplicationGroupInfo().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getPendingModifiedValues() == null ? 0 : this.getPendingModifiedValues().hashCode());
        hashCode = 31 * hashCode + (this.getMemberClusters() == null ? 0 : this.getMemberClusters().hashCode());
        hashCode = 31 * hashCode + (this.getNodeGroups() == null ? 0 : this.getNodeGroups().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshottingClusterId() == null ? 0 : this.getSnapshottingClusterId().hashCode());
        hashCode = 31 * hashCode + (this.getAutomaticFailover() == null ? 0 : this.getAutomaticFailover().hashCode());
        hashCode = 31 * hashCode + (this.getMultiAZ() == null ? 0 : this.getMultiAZ().hashCode());
        hashCode = 31 * hashCode + (this.getConfigurationEndpoint() == null ? 0 : this.getConfigurationEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotRetentionLimit() == null ? 0 : this.getSnapshotRetentionLimit().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotWindow() == null ? 0 : this.getSnapshotWindow().hashCode());
        hashCode = 31 * hashCode + (this.getClusterEnabled() == null ? 0 : this.getClusterEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getCacheNodeType() == null ? 0 : this.getCacheNodeType().hashCode());
        hashCode = 31 * hashCode + (this.getAuthTokenEnabled() == null ? 0 : this.getAuthTokenEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getAuthTokenLastModifiedDate() == null ? 0 : this.getAuthTokenLastModifiedDate().hashCode());
        hashCode = 31 * hashCode + (this.getTransitEncryptionEnabled() == null ? 0 : this.getTransitEncryptionEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getAtRestEncryptionEnabled() == null ? 0 : this.getAtRestEncryptionEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getMemberClustersOutpostArns() == null ? 0 : this.getMemberClustersOutpostArns().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getARN() == null ? 0 : this.getARN().hashCode());
        hashCode = 31 * hashCode + (this.getUserGroupIds() == null ? 0 : this.getUserGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.getLogDeliveryConfigurations() == null ? 0 : this.getLogDeliveryConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getReplicationGroupCreateTime() == null ? 0 : this.getReplicationGroupCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getDataTiering() == null ? 0 : this.getDataTiering().hashCode());
        hashCode = 31 * hashCode + (this.getAutoMinorVersionUpgrade() == null ? 0 : this.getAutoMinorVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkType() == null ? 0 : this.getNetworkType().hashCode());
        hashCode = 31 * hashCode + (this.getIpDiscovery() == null ? 0 : this.getIpDiscovery().hashCode());
        hashCode = 31 * hashCode + (this.getTransitEncryptionMode() == null ? 0 : this.getTransitEncryptionMode().hashCode());
        hashCode = 31 * hashCode + (this.getClusterMode() == null ? 0 : this.getClusterMode().hashCode());
        return hashCode;
    }

    public ReplicationGroup clone() {
        try {
            return (ReplicationGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

