/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevidently.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cloudwatchevidently.model.EvaluationRule;
import com.amazonaws.services.cloudwatchevidently.model.FeatureEvaluationStrategy;
import com.amazonaws.services.cloudwatchevidently.model.FeatureStatus;
import com.amazonaws.services.cloudwatchevidently.model.transform.FeatureSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FeatureSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private Date createdTime;
    private String defaultVariation;
    private List<EvaluationRule> evaluationRules;
    private String evaluationStrategy;
    private Date lastUpdatedTime;
    private String name;
    private String project;
    private String status;
    private Map<String, String> tags;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public FeatureSummary withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public FeatureSummary withCreatedTime(Date createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public void setDefaultVariation(String defaultVariation) {
        this.defaultVariation = defaultVariation;
    }

    public String getDefaultVariation() {
        return this.defaultVariation;
    }

    public FeatureSummary withDefaultVariation(String defaultVariation) {
        this.setDefaultVariation(defaultVariation);
        return this;
    }

    public List<EvaluationRule> getEvaluationRules() {
        return this.evaluationRules;
    }

    public void setEvaluationRules(Collection<EvaluationRule> evaluationRules) {
        if (evaluationRules == null) {
            this.evaluationRules = null;
            return;
        }
        this.evaluationRules = new ArrayList<EvaluationRule>(evaluationRules);
    }

    public FeatureSummary withEvaluationRules(EvaluationRule ... evaluationRules) {
        if (this.evaluationRules == null) {
            this.setEvaluationRules(new ArrayList<EvaluationRule>(evaluationRules.length));
        }
        for (EvaluationRule ele : evaluationRules) {
            this.evaluationRules.add(ele);
        }
        return this;
    }

    public FeatureSummary withEvaluationRules(Collection<EvaluationRule> evaluationRules) {
        this.setEvaluationRules(evaluationRules);
        return this;
    }

    public void setEvaluationStrategy(String evaluationStrategy) {
        this.evaluationStrategy = evaluationStrategy;
    }

    public String getEvaluationStrategy() {
        return this.evaluationStrategy;
    }

    public FeatureSummary withEvaluationStrategy(String evaluationStrategy) {
        this.setEvaluationStrategy(evaluationStrategy);
        return this;
    }

    public FeatureSummary withEvaluationStrategy(FeatureEvaluationStrategy evaluationStrategy) {
        this.evaluationStrategy = evaluationStrategy.toString();
        return this;
    }

    public void setLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public Date getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public FeatureSummary withLastUpdatedTime(Date lastUpdatedTime) {
        this.setLastUpdatedTime(lastUpdatedTime);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public FeatureSummary withName(String name) {
        this.setName(name);
        return this;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getProject() {
        return this.project;
    }

    public FeatureSummary withProject(String project) {
        this.setProject(project);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public FeatureSummary withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public FeatureSummary withStatus(FeatureStatus status) {
        this.status = status.toString();
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public FeatureSummary withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public FeatureSummary addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public FeatureSummary clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: ").append(this.getCreatedTime()).append(",");
        }
        if (this.getDefaultVariation() != null) {
            sb.append("DefaultVariation: ").append(this.getDefaultVariation()).append(",");
        }
        if (this.getEvaluationRules() != null) {
            sb.append("EvaluationRules: ").append(this.getEvaluationRules()).append(",");
        }
        if (this.getEvaluationStrategy() != null) {
            sb.append("EvaluationStrategy: ").append(this.getEvaluationStrategy()).append(",");
        }
        if (this.getLastUpdatedTime() != null) {
            sb.append("LastUpdatedTime: ").append(this.getLastUpdatedTime()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getProject() != null) {
            sb.append("Project: ").append(this.getProject()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FeatureSummary)) {
            return false;
        }
        FeatureSummary other = (FeatureSummary)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        if (other.getCreatedTime() != null && !other.getCreatedTime().equals(this.getCreatedTime())) {
            return false;
        }
        if (other.getDefaultVariation() == null ^ this.getDefaultVariation() == null) {
            return false;
        }
        if (other.getDefaultVariation() != null && !other.getDefaultVariation().equals(this.getDefaultVariation())) {
            return false;
        }
        if (other.getEvaluationRules() == null ^ this.getEvaluationRules() == null) {
            return false;
        }
        if (other.getEvaluationRules() != null && !other.getEvaluationRules().equals(this.getEvaluationRules())) {
            return false;
        }
        if (other.getEvaluationStrategy() == null ^ this.getEvaluationStrategy() == null) {
            return false;
        }
        if (other.getEvaluationStrategy() != null && !other.getEvaluationStrategy().equals(this.getEvaluationStrategy())) {
            return false;
        }
        if (other.getLastUpdatedTime() == null ^ this.getLastUpdatedTime() == null) {
            return false;
        }
        if (other.getLastUpdatedTime() != null && !other.getLastUpdatedTime().equals(this.getLastUpdatedTime())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getProject() == null ^ this.getProject() == null) {
            return false;
        }
        if (other.getProject() != null && !other.getProject().equals(this.getProject())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultVariation() == null ? 0 : this.getDefaultVariation().hashCode());
        hashCode = 31 * hashCode + (this.getEvaluationRules() == null ? 0 : this.getEvaluationRules().hashCode());
        hashCode = 31 * hashCode + (this.getEvaluationStrategy() == null ? 0 : this.getEvaluationStrategy().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedTime() == null ? 0 : this.getLastUpdatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getProject() == null ? 0 : this.getProject().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public FeatureSummary clone() {
        try {
            return (FeatureSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FeatureSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

