/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudformation.model.DescribeChangeSetRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeChangeSetRequestMarshaller
implements Marshaller<Request<DescribeChangeSetRequest>, DescribeChangeSetRequest> {
    public Request<DescribeChangeSetRequest> marshall(DescribeChangeSetRequest describeChangeSetRequest) {
        if (describeChangeSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeChangeSetRequest, "AmazonCloudFormation");
        request.addParameter("Action", "DescribeChangeSet");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeChangeSetRequest.getChangeSetName() != null) {
            request.addParameter("ChangeSetName", StringUtils.fromString((String)describeChangeSetRequest.getChangeSetName()));
        }
        if (describeChangeSetRequest.getStackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)describeChangeSetRequest.getStackName()));
        }
        if (describeChangeSetRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeChangeSetRequest.getNextToken()));
        }
        if (describeChangeSetRequest.getIncludePropertyValues() != null) {
            request.addParameter("IncludePropertyValues", StringUtils.fromBoolean((Boolean)describeChangeSetRequest.getIncludePropertyValues()));
        }
        return request;
    }
}

