/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.chimesdkvoice.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateVoiceConnector"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateVoiceConnectorRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The name of the Voice Connector.
     * </p>
     */
    private String name;
    /**
     * <p>
     * The AWS Region in which the Amazon Chime SDK Voice Connector is created. Default value: <code>us-east-1</code> .
     * </p>
     */
    private String awsRegion;
    /**
     * <p>
     * Enables or disables encryption for the Voice Connector.
     * </p>
     */
    private Boolean requireEncryption;
    /**
     * <p>
     * The tags assigned to the Voice Connector.
     * </p>
     */
    private java.util.List<Tag> tags;

    /**
     * <p>
     * The name of the Voice Connector.
     * </p>
     * 
     * @param name
     *        The name of the Voice Connector.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name of the Voice Connector.
     * </p>
     * 
     * @return The name of the Voice Connector.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name of the Voice Connector.
     * </p>
     * 
     * @param name
     *        The name of the Voice Connector.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateVoiceConnectorRequest withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * The AWS Region in which the Amazon Chime SDK Voice Connector is created. Default value: <code>us-east-1</code> .
     * </p>
     * 
     * @param awsRegion
     *        The AWS Region in which the Amazon Chime SDK Voice Connector is created. Default value:
     *        <code>us-east-1</code> .
     * @see VoiceConnectorAwsRegion
     */

    public void setAwsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
    }

    /**
     * <p>
     * The AWS Region in which the Amazon Chime SDK Voice Connector is created. Default value: <code>us-east-1</code> .
     * </p>
     * 
     * @return The AWS Region in which the Amazon Chime SDK Voice Connector is created. Default value:
     *         <code>us-east-1</code> .
     * @see VoiceConnectorAwsRegion
     */

    public String getAwsRegion() {
        return this.awsRegion;
    }

    /**
     * <p>
     * The AWS Region in which the Amazon Chime SDK Voice Connector is created. Default value: <code>us-east-1</code> .
     * </p>
     * 
     * @param awsRegion
     *        The AWS Region in which the Amazon Chime SDK Voice Connector is created. Default value:
     *        <code>us-east-1</code> .
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see VoiceConnectorAwsRegion
     */

    public CreateVoiceConnectorRequest withAwsRegion(String awsRegion) {
        setAwsRegion(awsRegion);
        return this;
    }

    /**
     * <p>
     * The AWS Region in which the Amazon Chime SDK Voice Connector is created. Default value: <code>us-east-1</code> .
     * </p>
     * 
     * @param awsRegion
     *        The AWS Region in which the Amazon Chime SDK Voice Connector is created. Default value:
     *        <code>us-east-1</code> .
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see VoiceConnectorAwsRegion
     */

    public CreateVoiceConnectorRequest withAwsRegion(VoiceConnectorAwsRegion awsRegion) {
        this.awsRegion = awsRegion.toString();
        return this;
    }

    /**
     * <p>
     * Enables or disables encryption for the Voice Connector.
     * </p>
     * 
     * @param requireEncryption
     *        Enables or disables encryption for the Voice Connector.
     */

    public void setRequireEncryption(Boolean requireEncryption) {
        this.requireEncryption = requireEncryption;
    }

    /**
     * <p>
     * Enables or disables encryption for the Voice Connector.
     * </p>
     * 
     * @return Enables or disables encryption for the Voice Connector.
     */

    public Boolean getRequireEncryption() {
        return this.requireEncryption;
    }

    /**
     * <p>
     * Enables or disables encryption for the Voice Connector.
     * </p>
     * 
     * @param requireEncryption
     *        Enables or disables encryption for the Voice Connector.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateVoiceConnectorRequest withRequireEncryption(Boolean requireEncryption) {
        setRequireEncryption(requireEncryption);
        return this;
    }

    /**
     * <p>
     * Enables or disables encryption for the Voice Connector.
     * </p>
     * 
     * @return Enables or disables encryption for the Voice Connector.
     */

    public Boolean isRequireEncryption() {
        return this.requireEncryption;
    }

    /**
     * <p>
     * The tags assigned to the Voice Connector.
     * </p>
     * 
     * @return The tags assigned to the Voice Connector.
     */

    public java.util.List<Tag> getTags() {
        return tags;
    }

    /**
     * <p>
     * The tags assigned to the Voice Connector.
     * </p>
     * 
     * @param tags
     *        The tags assigned to the Voice Connector.
     */

    public void setTags(java.util.Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }

        this.tags = new java.util.ArrayList<Tag>(tags);
    }

    /**
     * <p>
     * The tags assigned to the Voice Connector.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTags(java.util.Collection)} or {@link #withTags(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param tags
     *        The tags assigned to the Voice Connector.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateVoiceConnectorRequest withTags(Tag... tags) {
        if (this.tags == null) {
            setTags(new java.util.ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The tags assigned to the Voice Connector.
     * </p>
     * 
     * @param tags
     *        The tags assigned to the Voice Connector.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateVoiceConnectorRequest withTags(java.util.Collection<Tag> tags) {
        setTags(tags);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getAwsRegion() != null)
            sb.append("AwsRegion: ").append(getAwsRegion()).append(",");
        if (getRequireEncryption() != null)
            sb.append("RequireEncryption: ").append(getRequireEncryption()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateVoiceConnectorRequest == false)
            return false;
        CreateVoiceConnectorRequest other = (CreateVoiceConnectorRequest) obj;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getAwsRegion() == null ^ this.getAwsRegion() == null)
            return false;
        if (other.getAwsRegion() != null && other.getAwsRegion().equals(this.getAwsRegion()) == false)
            return false;
        if (other.getRequireEncryption() == null ^ this.getRequireEncryption() == null)
            return false;
        if (other.getRequireEncryption() != null && other.getRequireEncryption().equals(this.getRequireEncryption()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getAwsRegion() == null) ? 0 : getAwsRegion().hashCode());
        hashCode = prime * hashCode + ((getRequireEncryption() == null) ? 0 : getRequireEncryption().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        return hashCode;
    }

    @Override
    public CreateVoiceConnectorRequest clone() {
        return (CreateVoiceConnectorRequest) super.clone();
    }

}
