/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backupgateway.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.backupgateway.model.VirtualMachineDetails;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class VirtualMachineDetailsMarshaller {
    private static final MarshallingInfo<String> HOSTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HostName").build();
    private static final MarshallingInfo<String> HYPERVISORID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HypervisorId").build();
    private static final MarshallingInfo<Date> LASTBACKUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastBackupDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> PATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Path").build();
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceArn").build();
    private static final MarshallingInfo<List> VMWARETAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VmwareTags").build();
    private static final VirtualMachineDetailsMarshaller instance = new VirtualMachineDetailsMarshaller();

    public static VirtualMachineDetailsMarshaller getInstance() {
        return instance;
    }

    public void marshall(VirtualMachineDetails virtualMachineDetails, ProtocolMarshaller protocolMarshaller) {
        if (virtualMachineDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)virtualMachineDetails.getHostName(), HOSTNAME_BINDING);
            protocolMarshaller.marshall((Object)virtualMachineDetails.getHypervisorId(), HYPERVISORID_BINDING);
            protocolMarshaller.marshall((Object)virtualMachineDetails.getLastBackupDate(), LASTBACKUPDATE_BINDING);
            protocolMarshaller.marshall((Object)virtualMachineDetails.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)virtualMachineDetails.getPath(), PATH_BINDING);
            protocolMarshaller.marshall((Object)virtualMachineDetails.getResourceArn(), RESOURCEARN_BINDING);
            protocolMarshaller.marshall(virtualMachineDetails.getVmwareTags(), VMWARETAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

