/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.accessanalyzer.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.accessanalyzer.model.Access;
import com.amazonaws.services.accessanalyzer.model.AccessCheckPolicyType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CheckAccessNotGrantedRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String policyDocument;
    private List<Access> access;
    private String policyType;

    public void setPolicyDocument(String policyDocument) {
        this.policyDocument = policyDocument;
    }

    public String getPolicyDocument() {
        return this.policyDocument;
    }

    public CheckAccessNotGrantedRequest withPolicyDocument(String policyDocument) {
        this.setPolicyDocument(policyDocument);
        return this;
    }

    public List<Access> getAccess() {
        return this.access;
    }

    public void setAccess(Collection<Access> access) {
        if (access == null) {
            this.access = null;
            return;
        }
        this.access = new ArrayList<Access>(access);
    }

    public CheckAccessNotGrantedRequest withAccess(Access ... access) {
        if (this.access == null) {
            this.setAccess(new ArrayList<Access>(access.length));
        }
        for (Access ele : access) {
            this.access.add(ele);
        }
        return this;
    }

    public CheckAccessNotGrantedRequest withAccess(Collection<Access> access) {
        this.setAccess(access);
        return this;
    }

    public void setPolicyType(String policyType) {
        this.policyType = policyType;
    }

    public String getPolicyType() {
        return this.policyType;
    }

    public CheckAccessNotGrantedRequest withPolicyType(String policyType) {
        this.setPolicyType(policyType);
        return this;
    }

    public CheckAccessNotGrantedRequest withPolicyType(AccessCheckPolicyType policyType) {
        this.policyType = policyType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPolicyDocument() != null) {
            sb.append("PolicyDocument: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getAccess() != null) {
            sb.append("Access: ").append(this.getAccess()).append(",");
        }
        if (this.getPolicyType() != null) {
            sb.append("PolicyType: ").append(this.getPolicyType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckAccessNotGrantedRequest)) {
            return false;
        }
        CheckAccessNotGrantedRequest other = (CheckAccessNotGrantedRequest)obj;
        if (other.getPolicyDocument() == null ^ this.getPolicyDocument() == null) {
            return false;
        }
        if (other.getPolicyDocument() != null && !other.getPolicyDocument().equals(this.getPolicyDocument())) {
            return false;
        }
        if (other.getAccess() == null ^ this.getAccess() == null) {
            return false;
        }
        if (other.getAccess() != null && !other.getAccess().equals(this.getAccess())) {
            return false;
        }
        if (other.getPolicyType() == null ^ this.getPolicyType() == null) {
            return false;
        }
        return other.getPolicyType() == null || other.getPolicyType().equals(this.getPolicyType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPolicyDocument() == null ? 0 : this.getPolicyDocument().hashCode());
        hashCode = 31 * hashCode + (this.getAccess() == null ? 0 : this.getAccess().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyType() == null ? 0 : this.getPolicyType().hashCode());
        return hashCode;
    }

    public CheckAccessNotGrantedRequest clone() {
        return (CheckAccessNotGrantedRequest)super.clone();
    }
}

