/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet.interfaces.core;

import com.amazon.speech.speechlet.SpeechletRequest;
import com.amazon.speech.speechlet.interfaces.core.AlexaSkillEventRequest;
import com.amazon.speech.speechlet.interfaces.core.Permission;
import com.amazon.speech.speechlet.interfaces.core.PermissionBody;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Date;
import java.util.List;
import java.util.Locale;

@JsonTypeName(value="AlexaSkillEvent.SkillPermissionAccepted")
public class PermissionAcceptedRequest
extends AlexaSkillEventRequest {
    private final PermissionBody body;
    private final Date eventCreationTime;
    private final Date eventPublishingTime;

    public static Builder builder() {
        return new Builder();
    }

    private PermissionAcceptedRequest(Builder builder) {
        super(builder);
        this.body = builder.body;
        this.eventCreationTime = builder.eventCreationTime;
        this.eventPublishingTime = builder.eventPublishingTime;
    }

    private PermissionAcceptedRequest(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="timestamp") Date timestamp, @JsonProperty(value="locale") Locale locale, @JsonProperty(value="body") PermissionBody body, @JsonProperty(value="eventCreationTime") Date eventCreationTime, @JsonProperty(value="eventPublishingTime") Date eventPublishingTime) {
        super(requestId, timestamp, locale);
        this.body = body;
        this.eventCreationTime = eventCreationTime;
        this.eventPublishingTime = eventPublishingTime;
    }

    public List<Permission> getAcceptedPermissionList() {
        List<Permission> permissions = this.body.getAcceptedPermissions();
        return permissions;
    }

    public Date getEventCreationTime() {
        return new Date(this.eventCreationTime.getTime());
    }

    public Date getEventPublishingTime() {
        return new Date(this.eventPublishingTime.getTime());
    }

    public static final class Builder
    extends SpeechletRequest.SpeechletRequestBuilder<Builder, PermissionAcceptedRequest> {
        private PermissionBody body;
        private Date eventCreationTime;
        private Date eventPublishingTime;

        private Builder() {
        }

        public Builder withPermissionBody(PermissionBody body) {
            this.body = body;
            return this;
        }

        public Builder withEventCreationTime(Date eventCreationTime) {
            this.eventCreationTime = new Date(eventCreationTime.getTime());
            return this;
        }

        public Builder withEventPublishingTime(Date eventPublishingTime) {
            this.eventPublishingTime = new Date(eventPublishingTime.getTime());
            return this;
        }

        @Override
        public PermissionAcceptedRequest build() {
            return new PermissionAcceptedRequest(this);
        }
    }
}

