/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet;

import com.amazon.speech.speechlet.Application;
import com.amazon.speech.speechlet.User;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;

public class Session {
    private final boolean isNew;
    private final String sessionId;
    private final Application application;
    private final Map<String, Object> attributes;
    private final User user;

    public static Builder builder() {
        return new Builder();
    }

    private Session(Builder builder) {
        this.isNew = builder.isNew;
        this.sessionId = builder.sessionId;
        this.application = builder.application;
        this.attributes = builder.attributes;
        this.user = builder.user;
    }

    private Session(@JsonProperty(value="new") boolean isNew, @JsonProperty(value="sessionId") String sessionId, @JsonProperty(value="application") Application application, @JsonProperty(value="attributes") Map<String, Object> attributes, @JsonProperty(value="user") User user) {
        this.isNew = isNew;
        this.sessionId = sessionId;
        this.application = application;
        this.attributes = attributes != null ? attributes : new HashMap<String, Object>();
        this.user = user;
    }

    private Session() {
        this.isNew = false;
        this.sessionId = null;
        this.application = null;
        this.attributes = new HashMap<String, Object>();
        this.user = null;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Application getApplication() {
        return this.application;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public User getUser() {
        return this.user;
    }

    public static final class Builder {
        private boolean isNew = false;
        private String sessionId;
        private Application application;
        private Map<String, Object> attributes = new HashMap<String, Object>();
        private User user;

        private Builder() {
        }

        public Builder withIsNew(boolean isNew) {
            this.isNew = isNew;
            return this;
        }

        public Builder withSessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder withApplication(Application application) {
            this.application = application;
            return this;
        }

        public Builder withAttributes(Map<String, Object> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder withUser(User user) {
            this.user = user;
            return this;
        }

        public Session build() {
            Validate.notBlank((CharSequence)this.sessionId, (String)"SessionId must be defined", (Object[])new Object[0]);
            return new Session(this);
        }
    }
}

