/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.json;

import com.amazon.speech.json.SerializedInterface;
import com.amazon.speech.speechlet.Context;
import com.amazon.speech.speechlet.State;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;

class ContextDeserializer
extends StdDeserializer<Context> {
    ContextDeserializer() {
        super(Context.class);
    }

    public Context deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        ObjectMapper underlyingMapper = (ObjectMapper)parser.getCodec();
        JsonNode messageNode = (JsonNode)parser.readValueAsTree();
        Context.Builder contextBuilder = Context.builder();
        for (SerializedInterface interfaceName : SerializedInterface.values()) {
            if (!messageNode.has(interfaceName.name()) || interfaceName.getStateClass() == null) continue;
            State state = (State)underlyingMapper.convertValue((Object)messageNode.get(interfaceName.name()), interfaceName.getStateClass());
            contextBuilder.addState(state);
        }
        return contextBuilder.build();
    }
}

