/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.spring.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public abstract class PropertySourcesUtils {
    public static Map<String, Object> getSubProperties(Iterable<PropertySource<?>> propertySources, String prefix) {
        AbstractEnvironment environment = new AbstractEnvironment(){};
        MutablePropertySources mutablePropertySources = environment.getPropertySources();
        for (PropertySource<?> source : propertySources) {
            mutablePropertySources.addLast(source);
        }
        return PropertySourcesUtils.getSubProperties((ConfigurableEnvironment)environment, prefix);
    }

    public static Map<String, Object> getSubProperties(ConfigurableEnvironment environment, String prefix) {
        LinkedHashMap<String, Object> subProperties = new LinkedHashMap<String, Object>();
        MutablePropertySources propertySources = environment.getPropertySources();
        String normalizedPrefix = PropertySourcesUtils.normalizePrefix(prefix);
        for (PropertySource source : propertySources) {
            if (!(source instanceof EnumerablePropertySource)) continue;
            for (String name : ((EnumerablePropertySource)source).getPropertyNames()) {
                String subName;
                if (subProperties.containsKey(name) || !name.startsWith(normalizedPrefix) || subProperties.containsKey(subName = name.substring(normalizedPrefix.length()))) continue;
                Object value = source.getProperty(name);
                if (value instanceof String) {
                    value = environment.resolvePlaceholders((String)value);
                }
                subProperties.put(subName, value);
            }
        }
        return Collections.unmodifiableMap(subProperties);
    }

    public static String normalizePrefix(String prefix) {
        return prefix.endsWith(".") ? prefix : prefix + ".";
    }
}

