/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.composite;

import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.dstu2.composite.SimpleQuantityDt;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.PositiveIntDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.List;

@DatatypeDef(name="SampledData")
public class SampledDataDt
extends BaseIdentifiableElement
implements ICompositeDatatype {
    @Child(name="origin", type={SimpleQuantityDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The base quantity that a measured value of zero represents. In addition, this provides the units of the entire measurement series")
    private SimpleQuantityDt myOrigin;
    @Child(name="period", type={DecimalDt.class}, order=1, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The length of time between sampling times, measured in milliseconds")
    private DecimalDt myPeriod;
    @Child(name="factor", type={DecimalDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A correction factor that is applied to the sampled data points before they are added to the origin")
    private DecimalDt myFactor;
    @Child(name="lowerLimit", type={DecimalDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The lower limit of detection of the measured points. This is needed if any of the data points have the value \"L\" (lower than detection limit)")
    private DecimalDt myLowerLimit;
    @Child(name="upperLimit", type={DecimalDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The upper limit of detection of the measured points. This is needed if any of the data points have the value \"U\" (higher than detection limit)")
    private DecimalDt myUpperLimit;
    @Child(name="dimensions", type={PositiveIntDt.class}, order=5, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The number of sample points at each time point. If this value is greater than one, then the dimensions will be interlaced - all the sample points for a point in time will be recorded at once")
    private PositiveIntDt myDimensions;
    @Child(name="data", type={StringDt.class}, order=6, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A series of data points which are decimal values separated by a single space (character u20). The special values \"E\" (error), \"L\" (below detection limit) and \"U\" (above detection limit) can also be used in place of a decimal value")
    private StringDt myData;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myOrigin, this.myPeriod, this.myFactor, this.myLowerLimit, this.myUpperLimit, this.myDimensions, this.myData});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myOrigin, this.myPeriod, this.myFactor, this.myLowerLimit, this.myUpperLimit, this.myDimensions, this.myData});
    }

    public SimpleQuantityDt getOrigin() {
        if (this.myOrigin == null) {
            this.myOrigin = new SimpleQuantityDt();
        }
        return this.myOrigin;
    }

    public SampledDataDt setOrigin(SimpleQuantityDt theValue) {
        this.myOrigin = theValue;
        return this;
    }

    public DecimalDt getPeriodElement() {
        if (this.myPeriod == null) {
            this.myPeriod = new DecimalDt();
        }
        return this.myPeriod;
    }

    public BigDecimal getPeriod() {
        return (BigDecimal)this.getPeriodElement().getValue();
    }

    public SampledDataDt setPeriod(DecimalDt theValue) {
        this.myPeriod = theValue;
        return this;
    }

    public SampledDataDt setPeriod(long theValue) {
        this.myPeriod = new DecimalDt(theValue);
        return this;
    }

    public SampledDataDt setPeriod(double theValue) {
        this.myPeriod = new DecimalDt(theValue);
        return this;
    }

    public SampledDataDt setPeriod(BigDecimal theValue) {
        this.myPeriod = new DecimalDt(theValue);
        return this;
    }

    public DecimalDt getFactorElement() {
        if (this.myFactor == null) {
            this.myFactor = new DecimalDt();
        }
        return this.myFactor;
    }

    public BigDecimal getFactor() {
        return (BigDecimal)this.getFactorElement().getValue();
    }

    public SampledDataDt setFactor(DecimalDt theValue) {
        this.myFactor = theValue;
        return this;
    }

    public SampledDataDt setFactor(long theValue) {
        this.myFactor = new DecimalDt(theValue);
        return this;
    }

    public SampledDataDt setFactor(double theValue) {
        this.myFactor = new DecimalDt(theValue);
        return this;
    }

    public SampledDataDt setFactor(BigDecimal theValue) {
        this.myFactor = new DecimalDt(theValue);
        return this;
    }

    public DecimalDt getLowerLimitElement() {
        if (this.myLowerLimit == null) {
            this.myLowerLimit = new DecimalDt();
        }
        return this.myLowerLimit;
    }

    public BigDecimal getLowerLimit() {
        return (BigDecimal)this.getLowerLimitElement().getValue();
    }

    public SampledDataDt setLowerLimit(DecimalDt theValue) {
        this.myLowerLimit = theValue;
        return this;
    }

    public SampledDataDt setLowerLimit(long theValue) {
        this.myLowerLimit = new DecimalDt(theValue);
        return this;
    }

    public SampledDataDt setLowerLimit(double theValue) {
        this.myLowerLimit = new DecimalDt(theValue);
        return this;
    }

    public SampledDataDt setLowerLimit(BigDecimal theValue) {
        this.myLowerLimit = new DecimalDt(theValue);
        return this;
    }

    public DecimalDt getUpperLimitElement() {
        if (this.myUpperLimit == null) {
            this.myUpperLimit = new DecimalDt();
        }
        return this.myUpperLimit;
    }

    public BigDecimal getUpperLimit() {
        return (BigDecimal)this.getUpperLimitElement().getValue();
    }

    public SampledDataDt setUpperLimit(DecimalDt theValue) {
        this.myUpperLimit = theValue;
        return this;
    }

    public SampledDataDt setUpperLimit(long theValue) {
        this.myUpperLimit = new DecimalDt(theValue);
        return this;
    }

    public SampledDataDt setUpperLimit(double theValue) {
        this.myUpperLimit = new DecimalDt(theValue);
        return this;
    }

    public SampledDataDt setUpperLimit(BigDecimal theValue) {
        this.myUpperLimit = new DecimalDt(theValue);
        return this;
    }

    public PositiveIntDt getDimensionsElement() {
        if (this.myDimensions == null) {
            this.myDimensions = new PositiveIntDt();
        }
        return this.myDimensions;
    }

    public Integer getDimensions() {
        return (Integer)this.getDimensionsElement().getValue();
    }

    public SampledDataDt setDimensions(PositiveIntDt theValue) {
        this.myDimensions = theValue;
        return this;
    }

    public SampledDataDt setDimensions(int theInteger) {
        this.myDimensions = new PositiveIntDt(theInteger);
        return this;
    }

    public StringDt getDataElement() {
        if (this.myData == null) {
            this.myData = new StringDt();
        }
        return this.myData;
    }

    public String getData() {
        return (String)this.getDataElement().getValue();
    }

    public SampledDataDt setData(StringDt theValue) {
        this.myData = theValue;
        return this;
    }

    public SampledDataDt setData(String theString) {
        this.myData = new StringDt(theString);
        return this;
    }
}

