/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.composite;

import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseCoding;

@DatatypeDef(name="Coding")
public class CodingDt
extends BaseCodingDt
implements ICompositeDatatype,
IBaseCoding {
    @Child(name="system", type={UriDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The identification of the code system that defines the meaning of the symbol in the code.")
    private UriDt mySystem;
    @Child(name="version", type={StringDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="The version of the code system which was used when choosing this code. Note that a well-maintained code system does not need the version reported, because the meaning of codes is consistent across versions. However this cannot consistently be assured. and when the meaning is not guaranteed to be consistent, the version SHOULD be exchanged")
    private StringDt myVersion;
    @Child(name="code", type={CodeDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A symbol in syntax defined by the system. The symbol may be a predefined code or an expression in a syntax defined by the coding system (e.g. post-coordination)")
    private CodeDt myCode;
    @Child(name="display", type={StringDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A representation of the meaning of the code in the system, following the rules of the system")
    private StringDt myDisplay;
    @Child(name="userSelected", type={BooleanDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Indicates that this coding was chosen by a user directly - i.e. off a pick list of available items (codes or displays)")
    private BooleanDt myUserSelected;

    public CodingDt() {
    }

    public CodingDt(String theSystem, String theCode) {
        this.setSystem(theSystem);
        this.setCode(theCode);
    }

    public CodingDt(BaseCodingDt theCoding) {
        this(theCoding.getSystemElement().getValueAsString(), (String)theCoding.getCodeElement().getValue());
    }

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.mySystem, this.myVersion, this.myCode, this.myDisplay, this.myUserSelected});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySystem, this.myVersion, this.myCode, this.myDisplay, this.myUserSelected});
    }

    public UriDt getSystemElement() {
        if (this.mySystem == null) {
            this.mySystem = new UriDt();
        }
        return this.mySystem;
    }

    public String getSystem() {
        return (String)this.getSystemElement().getValue();
    }

    public CodingDt setSystem(UriDt theValue) {
        this.mySystem = theValue;
        return this;
    }

    public CodingDt setSystem(String theUri) {
        this.mySystem = new UriDt(theUri);
        return this;
    }

    public StringDt getVersionElement() {
        if (this.myVersion == null) {
            this.myVersion = new StringDt();
        }
        return this.myVersion;
    }

    public String getVersion() {
        return (String)this.getVersionElement().getValue();
    }

    public CodingDt setVersion(StringDt theValue) {
        this.myVersion = theValue;
        return this;
    }

    public CodingDt setVersion(String theString) {
        this.myVersion = new StringDt(theString);
        return this;
    }

    public CodeDt getCodeElement() {
        if (this.myCode == null) {
            this.myCode = new CodeDt();
        }
        return this.myCode;
    }

    public String getCode() {
        return (String)this.getCodeElement().getValue();
    }

    public CodingDt setCode(CodeDt theValue) {
        this.myCode = theValue;
        return this;
    }

    public CodingDt setCode(String theCode) {
        this.myCode = new CodeDt(theCode);
        return this;
    }

    public StringDt getDisplayElement() {
        if (this.myDisplay == null) {
            this.myDisplay = new StringDt();
        }
        return this.myDisplay;
    }

    public String getDisplay() {
        return (String)this.getDisplayElement().getValue();
    }

    public CodingDt setDisplay(StringDt theValue) {
        this.myDisplay = theValue;
        return this;
    }

    public CodingDt setDisplay(String theString) {
        this.myDisplay = new StringDt(theString);
        return this;
    }

    public BooleanDt getUserSelectedElement() {
        if (this.myUserSelected == null) {
            this.myUserSelected = new BooleanDt();
        }
        return this.myUserSelected;
    }

    public Boolean getUserSelected() {
        return (Boolean)this.getUserSelectedElement().getValue();
    }

    public CodingDt setUserSelected(BooleanDt theValue) {
        this.myUserSelected = theValue;
        return this;
    }

    public CodingDt setUserSelected(boolean theBoolean) {
        this.myUserSelected = new BooleanDt(theBoolean);
        return this;
    }
}

