/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.rest.method.MethodUtil;
import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.ObjectUtil;
import ca.uhn.fhir.validation.BaseValidationContext;
import ca.uhn.fhir.validation.IValidationContext;
import ca.uhn.fhir.validation.SingleValidationMessage;
import ca.uhn.fhir.validation.ValidationResult;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class ValidationContext<T>
extends BaseValidationContext<T>
implements IValidationContext<T> {
    private final IEncoder myEncoder;
    private final T myResource;
    private String myResourceAsString;
    private final EncodingEnum myResourceAsStringEncoding;

    private ValidationContext(FhirContext theContext, T theResource, IEncoder theEncoder) {
        super(theContext);
        this.myResource = theResource;
        this.myEncoder = theEncoder;
        this.myResourceAsStringEncoding = theEncoder != null ? theEncoder.getEncoding() : null;
    }

    @Override
    public T getResource() {
        return this.myResource;
    }

    @Override
    public String getResourceAsString() {
        if (this.myResourceAsString == null) {
            this.myResourceAsString = this.myEncoder.encode();
        }
        return this.myResourceAsString;
    }

    @Override
    public EncodingEnum getResourceAsStringEncoding() {
        return this.myResourceAsStringEncoding;
    }

    public static IValidationContext<Bundle> forBundle(final FhirContext theContext, final Bundle theBundle) {
        return new ValidationContext<Bundle>(theContext, theBundle, new IEncoder(){

            @Override
            public String encode() {
                return theContext.newXmlParser().encodeBundleToString(theBundle);
            }

            @Override
            public EncodingEnum getEncoding() {
                return EncodingEnum.XML;
            }
        });
    }

    public static <T extends IBaseResource> IValidationContext<T> forResource(final FhirContext theContext, final T theResource) {
        return new ValidationContext<T>(theContext, theResource, new IEncoder(){

            @Override
            public String encode() {
                return theContext.newXmlParser().encodeResourceToString(theResource);
            }

            @Override
            public EncodingEnum getEncoding() {
                return EncodingEnum.XML;
            }
        });
    }

    public static IValidationContext<IBaseResource> newChild(final IValidationContext<Bundle> theContext, final IResource theResource) {
        return new IValidationContext<IBaseResource>(){

            @Override
            public void addValidationMessage(SingleValidationMessage theMessage) {
                theContext.addValidationMessage(theMessage);
            }

            @Override
            public FhirContext getFhirContext() {
                return theContext.getFhirContext();
            }

            @Override
            public IBaseResource getResource() {
                return theResource;
            }

            @Override
            public String getResourceAsString() {
                return theContext.getFhirContext().newXmlParser().encodeResourceToString(theResource);
            }

            @Override
            public EncodingEnum getResourceAsStringEncoding() {
                return EncodingEnum.XML;
            }

            @Override
            public ValidationResult toResult() {
                return theContext.toResult();
            }
        };
    }

    public static IValidationContext<IBaseResource> forText(final FhirContext theContext, final String theResourceBody) {
        ObjectUtil.requireNonNull(theContext, "theContext can not be null");
        ObjectUtil.requireNotEmpty(theResourceBody, "theResourceBody can not be null or empty");
        return new BaseValidationContext<IBaseResource>(theContext){
            private EncodingEnum myEncoding;
            private IBaseResource myParsed;

            @Override
            public IBaseResource getResource() {
                if (this.myParsed == null) {
                    this.myParsed = this.getResourceAsStringEncoding().newParser(this.getFhirContext()).parseResource(this.getResourceAsString());
                }
                return this.myParsed;
            }

            @Override
            public String getResourceAsString() {
                return theResourceBody;
            }

            @Override
            public EncodingEnum getResourceAsStringEncoding() {
                if (this.myEncoding == null) {
                    this.myEncoding = MethodUtil.detectEncodingNoDefault(theResourceBody);
                    if (this.myEncoding == null) {
                        throw new InvalidRequestException(theContext.getLocalizer().getMessage(ValidationContext.class, "unableToDetermineEncoding", new Object[0]));
                    }
                }
                return this.myEncoding;
            }
        };
    }

    private static interface IEncoder {
        public String encode();

        public EncodingEnum getEncoding();
    }
}

