/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.auth;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.interceptor.auth.AppliesTypeEnum;
import ca.uhn.fhir.rest.server.interceptor.auth.AuthorizationInterceptor;
import ca.uhn.fhir.rest.server.interceptor.auth.BaseRule;
import ca.uhn.fhir.rest.server.interceptor.auth.ClassifierTypeEnum;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRule;
import ca.uhn.fhir.rest.server.interceptor.auth.IRuleApplier;
import ca.uhn.fhir.rest.server.interceptor.auth.PolicyEnum;
import ca.uhn.fhir.rest.server.interceptor.auth.RuleOpEnum;
import ca.uhn.fhir.rest.server.interceptor.auth.TransactionAppliesToEnum;
import ca.uhn.fhir.util.BundleUtil;
import ca.uhn.fhir.util.FhirTerser;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

class RuleImplOp
extends BaseRule
implements IAuthRule {
    private AppliesTypeEnum myAppliesTo;
    private Set<?> myAppliesToTypes;
    private String myClassifierCompartmentName;
    private Collection<? extends IIdType> myClassifierCompartmentOwners;
    private ClassifierTypeEnum myClassifierType;
    private RuleOpEnum myOp;
    private TransactionAppliesToEnum myTransactionAppliesToOp;

    public RuleImplOp(String theRuleName) {
        super(theRuleName);
    }

    @Override
    public AuthorizationInterceptor.Verdict applyRule(RestOperationTypeEnum theOperation, RequestDetails theRequestDetails, IBaseResource theInputResource, IIdType theInputResourceId, IBaseResource theOutputResource, IRuleApplier theRuleApplier) {
        IBaseResource appliesToResource;
        FhirContext ctx = theRequestDetails.getServer().getFhirContext();
        IIdType appliesToResourceId = null;
        block0 : switch (this.myOp) {
            case READ: {
                if (theOutputResource == null) {
                    switch (theOperation) {
                        case READ: 
                        case VREAD: {
                            appliesToResourceId = theInputResourceId;
                            break;
                        }
                        case SEARCH_SYSTEM: 
                        case SEARCH_TYPE: 
                        case HISTORY_INSTANCE: 
                        case HISTORY_SYSTEM: {
                            return new AuthorizationInterceptor.Verdict(PolicyEnum.ALLOW, this);
                        }
                        default: {
                            return null;
                        }
                    }
                }
                appliesToResource = theOutputResource;
                break;
            }
            case WRITE: {
                if (theInputResource == null && theInputResourceId == null) {
                    return null;
                }
                switch (theOperation) {
                    case CREATE: 
                    case UPDATE: 
                    case ADD_TAGS: 
                    case DELETE_TAGS: 
                    case META_ADD: 
                    case META_DELETE: 
                    case PATCH: {
                        appliesToResource = theInputResource;
                        appliesToResourceId = theInputResourceId;
                        break block0;
                    }
                }
                return null;
            }
            case DELETE: {
                if (theOperation == RestOperationTypeEnum.DELETE) {
                    if (theInputResource == null) {
                        return this.newVerdict();
                    }
                    appliesToResource = theInputResource;
                    break;
                }
                return null;
            }
            case BATCH: 
            case TRANSACTION: {
                if (theInputResource != null && this.requestAppliesToTransaction(ctx, this.myOp, theInputResource)) {
                    if (this.getMode() == PolicyEnum.DENY) {
                        return new AuthorizationInterceptor.Verdict(PolicyEnum.DENY, this);
                    }
                    List<BundleUtil.BundleEntryParts> inputResources = BundleUtil.toListOfEntries(ctx, (IBaseBundle)theInputResource);
                    AuthorizationInterceptor.Verdict verdict = null;
                    for (BundleUtil.BundleEntryParts bundleEntryParts : inputResources) {
                        IBaseResource inputResource = bundleEntryParts.getResource();
                        RestOperationTypeEnum operation = null;
                        if (bundleEntryParts.getRequestType() == RequestTypeEnum.GET) continue;
                        if (bundleEntryParts.getRequestType() == RequestTypeEnum.POST) {
                            operation = RestOperationTypeEnum.CREATE;
                        } else if (bundleEntryParts.getRequestType() == RequestTypeEnum.PUT) {
                            operation = RestOperationTypeEnum.UPDATE;
                        } else {
                            throw new InvalidRequestException("Can not handle transaction with operation of type " + (Object)((Object)bundleEntryParts.getRequestType()));
                        }
                        RuntimeResourceDefinition resourceDef = ctx.getResourceDefinition(bundleEntryParts.getResource());
                        if ("Parameters".equals(resourceDef.getName()) || "Bundle".equals(resourceDef.getName())) {
                            throw new InvalidRequestException("Can not handle transaction with nested resource of type " + resourceDef.getName());
                        }
                        AuthorizationInterceptor.Verdict newVerdict = theRuleApplier.applyRulesAndReturnDecision(operation, theRequestDetails, inputResource, null, null);
                        if (newVerdict == null) continue;
                        if (verdict == null) {
                            verdict = newVerdict;
                            continue;
                        }
                        if (verdict.getDecision() != PolicyEnum.ALLOW || newVerdict.getDecision() != PolicyEnum.DENY) continue;
                        verdict = newVerdict;
                    }
                    return verdict;
                }
                if (theOutputResource != null) {
                    List<BundleUtil.BundleEntryParts> inputResources = BundleUtil.toListOfEntries(ctx, (IBaseBundle)theInputResource);
                    AuthorizationInterceptor.Verdict verdict = null;
                    for (BundleUtil.BundleEntryParts bundleEntryParts : inputResources) {
                        AuthorizationInterceptor.Verdict newVerdict;
                        if (bundleEntryParts.getResource() == null || (newVerdict = theRuleApplier.applyRulesAndReturnDecision(RestOperationTypeEnum.READ, theRequestDetails, null, null, bundleEntryParts.getResource())) == null) continue;
                        if (verdict == null) {
                            verdict = newVerdict;
                            continue;
                        }
                        if (verdict.getDecision() != PolicyEnum.ALLOW || newVerdict.getDecision() != PolicyEnum.DENY) continue;
                        verdict = newVerdict;
                    }
                    return verdict;
                }
                return null;
            }
            case ALLOW_ALL: {
                return new AuthorizationInterceptor.Verdict(PolicyEnum.ALLOW, this);
            }
            case DENY_ALL: {
                return new AuthorizationInterceptor.Verdict(PolicyEnum.DENY, this);
            }
            case METADATA: {
                if (theOperation == RestOperationTypeEnum.METADATA) {
                    return this.newVerdict();
                }
                return null;
            }
            default: {
                throw new IllegalStateException("Unable to apply security to event of type " + (Object)((Object)theOperation));
            }
        }
        switch (this.myAppliesTo) {
            case ALL_RESOURCES: {
                break;
            }
            case TYPES: {
                Class type;
                if (appliesToResource != null && !this.myAppliesToTypes.contains(appliesToResource.getClass())) {
                    return null;
                }
                if (appliesToResourceId == null || this.myAppliesToTypes.contains(type = theRequestDetails.getServer().getFhirContext().getResourceDefinition(appliesToResourceId.getResourceType()).getImplementingClass())) break;
                return null;
            }
            default: {
                throw new IllegalStateException("Unable to apply security to event of applies to type " + (Object)((Object)this.myAppliesTo));
            }
        }
        switch (this.myClassifierType) {
            case ANY_ID: {
                break;
            }
            case IN_COMPARTMENT: {
                FhirTerser t = ctx.newTerser();
                boolean foundMatch = false;
                for (IIdType iIdType : this.myClassifierCompartmentOwners) {
                    if (appliesToResource != null && t.isSourceInCompartmentForTarget(this.myClassifierCompartmentName, appliesToResource, iIdType)) {
                        foundMatch = true;
                        break;
                    }
                    if (appliesToResourceId == null || !appliesToResourceId.hasResourceType() || !appliesToResourceId.hasIdPart() || !appliesToResourceId.toUnqualifiedVersionless().getValue().equals(iIdType.toUnqualifiedVersionless().getValue())) continue;
                    foundMatch = true;
                    break;
                }
                if (foundMatch) break;
                return null;
            }
            default: {
                throw new IllegalStateException("Unable to apply security to event of applies to type " + (Object)((Object)this.myAppliesTo));
            }
        }
        return this.newVerdict();
    }

    private boolean requestAppliesToTransaction(FhirContext theContext, RuleOpEnum theOp, IBaseResource theInputResource) {
        if (!"Bundle".equals(theContext.getResourceDefinition(theInputResource).getName())) {
            return false;
        }
        IBaseBundle request = (IBaseBundle)theInputResource;
        String bundleType = BundleUtil.getBundleType(theContext, request);
        switch (theOp) {
            case TRANSACTION: {
                return "transaction".equals(bundleType);
            }
            case BATCH: {
                return "batch".equals(bundleType);
            }
        }
        return false;
    }

    public TransactionAppliesToEnum getTransactionAppliesToOp() {
        return this.myTransactionAppliesToOp;
    }

    public void setAppliesTo(AppliesTypeEnum theAppliesTo) {
        this.myAppliesTo = theAppliesTo;
    }

    public void setAppliesToTypes(Set<?> theAppliesToTypes) {
        this.myAppliesToTypes = theAppliesToTypes;
    }

    public void setClassifierCompartmentName(String theClassifierCompartmentName) {
        this.myClassifierCompartmentName = theClassifierCompartmentName;
    }

    public void setClassifierCompartmentOwners(Collection<? extends IIdType> theInCompartmentOwners) {
        this.myClassifierCompartmentOwners = theInCompartmentOwners;
    }

    public void setClassifierType(ClassifierTypeEnum theClassifierType) {
        this.myClassifierType = theClassifierType;
    }

    public RuleImplOp setOp(RuleOpEnum theRuleOp) {
        this.myOp = theRuleOp;
        return this;
    }

    public void setTransactionAppliesToOp(TransactionAppliesToEnum theOp) {
        this.myTransactionAppliesToOp = theOp;
    }
}

