/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.auth;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.AuthenticationException;
import ca.uhn.fhir.rest.server.exceptions.ForbiddenOperationException;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import ca.uhn.fhir.rest.server.interceptor.IServerOperationInterceptor;
import ca.uhn.fhir.rest.server.interceptor.InterceptorAdapter;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRule;
import ca.uhn.fhir.rest.server.interceptor.auth.IRuleApplier;
import ca.uhn.fhir.rest.server.interceptor.auth.PolicyEnum;
import ca.uhn.fhir.util.CoverageIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationInterceptor
extends InterceptorAdapter
implements IServerOperationInterceptor,
IRuleApplier {
    private static final Logger ourLog = LoggerFactory.getLogger(AuthorizationInterceptor.class);
    private PolicyEnum myDefaultPolicy = PolicyEnum.DENY;

    public AuthorizationInterceptor() {
    }

    public AuthorizationInterceptor(PolicyEnum theDefaultPolicy) {
        this();
        this.setDefaultPolicy(theDefaultPolicy);
    }

    private void applyRulesAndFailIfDeny(RestOperationTypeEnum theOperation, RequestDetails theRequestDetails, IBaseResource theInputResource, IIdType theInputResourceId, IBaseResource theOutputResource) {
        Verdict decision = this.applyRulesAndReturnDecision(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource);
        if (decision.getDecision() == PolicyEnum.ALLOW) {
            return;
        }
        this.handleDeny(decision);
    }

    @Override
    public Verdict applyRulesAndReturnDecision(RestOperationTypeEnum theOperation, RequestDetails theRequestDetails, IBaseResource theInputResource, IIdType theInputResourceId, IBaseResource theOutputResource) {
        List<IAuthRule> rules = this.buildRuleList(theRequestDetails);
        ourLog.trace("Applying {} rules to render an auth decision for operation {}", (Object)rules.size(), (Object)theOperation);
        Verdict verdict = null;
        for (IAuthRule nextRule : rules) {
            verdict = nextRule.applyRule(theOperation, theRequestDetails, theInputResource, theInputResourceId, theOutputResource, this);
            if (verdict == null) continue;
            ourLog.trace("Rule {} returned decision {}", (Object)nextRule, (Object)verdict.getDecision());
            break;
        }
        if (verdict == null) {
            ourLog.trace("No rules returned a decision, applying default {}", (Object)this.myDefaultPolicy);
            return new Verdict(this.myDefaultPolicy, null);
        }
        return verdict;
    }

    public List<IAuthRule> buildRuleList(RequestDetails theRequestDetails) {
        return new ArrayList<IAuthRule>();
    }

    private OperationExamineDirection determineOperationDirection(RestOperationTypeEnum theOperation, IBaseResource theRequestResource) {
        switch (theOperation) {
            case ADD_TAGS: 
            case DELETE_TAGS: 
            case GET_TAGS: {
                return OperationExamineDirection.NONE;
            }
            case EXTENDED_OPERATION_INSTANCE: 
            case EXTENDED_OPERATION_SERVER: 
            case EXTENDED_OPERATION_TYPE: {
                return OperationExamineDirection.BOTH;
            }
            case METADATA: {
                return OperationExamineDirection.IN;
            }
            case DELETE: {
                return OperationExamineDirection.NONE;
            }
            case CREATE: 
            case UPDATE: {
                return OperationExamineDirection.IN;
            }
            case META: 
            case META_ADD: 
            case META_DELETE: {
                return OperationExamineDirection.NONE;
            }
            case GET_PAGE: 
            case HISTORY_INSTANCE: 
            case HISTORY_SYSTEM: 
            case HISTORY_TYPE: 
            case READ: 
            case SEARCH_SYSTEM: 
            case SEARCH_TYPE: 
            case VREAD: {
                return OperationExamineDirection.OUT;
            }
            case TRANSACTION: {
                return OperationExamineDirection.BOTH;
            }
            case VALIDATE: {
                return OperationExamineDirection.NONE;
            }
        }
        throw new IllegalStateException("Unable to apply security to event of type " + (Object)((Object)theOperation));
    }

    public PolicyEnum getDefaultPolicy() {
        return this.myDefaultPolicy;
    }

    protected void handleDeny(Verdict decision) {
        if (decision.getDecidingRule() != null) {
            String ruleName = StringUtils.defaultString((String)decision.getDecidingRule().getName(), (String)"(unnamed rule)");
            throw new ForbiddenOperationException("Access denied by rule: " + ruleName);
        }
        throw new ForbiddenOperationException("Access denied by default policy (no applicable rules)");
    }

    private void handleUserOperation(RequestDetails theRequest, IBaseResource theResource, RestOperationTypeEnum operation) {
        this.applyRulesAndFailIfDeny(operation, theRequest, theResource, theResource.getIdElement(), null);
    }

    @Override
    public void incomingRequestPreHandled(RestOperationTypeEnum theOperation, IServerInterceptor.ActionRequestDetails theProcessedRequest) {
        IBaseResource inputResource = null;
        IIdType inputResourceId = null;
        switch (this.determineOperationDirection(theOperation, theProcessedRequest.getResource())) {
            case IN: 
            case BOTH: {
                inputResource = theProcessedRequest.getResource();
                inputResourceId = theProcessedRequest.getId();
                break;
            }
            case OUT: {
                inputResource = null;
                inputResourceId = theProcessedRequest.getId();
                break;
            }
            case NONE: {
                return;
            }
        }
        RequestDetails requestDetails = theProcessedRequest.getRequestDetails();
        this.applyRulesAndFailIfDeny(theOperation, requestDetails, inputResource, inputResourceId, null);
    }

    @Override
    @CoverageIgnore
    public boolean outgoingResponse(RequestDetails theRequestDetails, Bundle theBundle) {
        throw AuthorizationInterceptor.failForDstu1();
    }

    @Override
    @CoverageIgnore
    public boolean outgoingResponse(RequestDetails theRequestDetails, Bundle theResponseObject, HttpServletRequest theServletRequest, HttpServletResponse theServletResponse) throws AuthenticationException {
        throw AuthorizationInterceptor.failForDstu1();
    }

    @Override
    public boolean outgoingResponse(RequestDetails theRequestDetails, IBaseResource theResponseObject) {
        switch (this.determineOperationDirection(theRequestDetails.getRestOperationType(), null)) {
            case IN: 
            case NONE: {
                return true;
            }
        }
        FhirContext fhirContext = theRequestDetails.getServer().getFhirContext();
        List<Object> resources = Collections.emptyList();
        switch (theRequestDetails.getRestOperationType()) {
            case EXTENDED_OPERATION_INSTANCE: 
            case EXTENDED_OPERATION_SERVER: 
            case EXTENDED_OPERATION_TYPE: 
            case HISTORY_INSTANCE: 
            case HISTORY_SYSTEM: 
            case HISTORY_TYPE: 
            case SEARCH_SYSTEM: 
            case SEARCH_TYPE: 
            case TRANSACTION: {
                if (theResponseObject == null) break;
                if (theResponseObject instanceof IBaseBundle) {
                    resources = this.toListOfResourcesAndExcludeContainer(theResponseObject, fhirContext);
                    break;
                }
                if (!(theResponseObject instanceof IBaseParameters)) break;
                resources = this.toListOfResourcesAndExcludeContainer(theResponseObject, fhirContext);
                break;
            }
            default: {
                if (theResponseObject == null) break;
                resources = Collections.singletonList(theResponseObject);
            }
        }
        for (IBaseResource nextResponse : resources) {
            this.applyRulesAndFailIfDeny(theRequestDetails.getRestOperationType(), theRequestDetails, null, null, nextResponse);
        }
        return true;
    }

    private List<IBaseResource> toListOfResourcesAndExcludeContainer(IBaseResource theResponseObject, FhirContext fhirContext) {
        List<IBaseResource> resources = fhirContext.newTerser().getAllPopulatedChildElementsOfType(theResponseObject, IBaseResource.class);
        if (resources.size() > 0 && resources.get(0) == theResponseObject) {
            resources = resources.subList(1, resources.size());
        }
        return resources;
    }

    @Override
    @CoverageIgnore
    public boolean outgoingResponse(RequestDetails theRequestDetails, TagList theResponseObject) {
        throw AuthorizationInterceptor.failForDstu1();
    }

    @Override
    @CoverageIgnore
    public boolean outgoingResponse(RequestDetails theRequestDetails, TagList theResponseObject, HttpServletRequest theServletRequest, HttpServletResponse theServletResponse) throws AuthenticationException {
        throw AuthorizationInterceptor.failForDstu1();
    }

    @Override
    public void resourceCreated(RequestDetails theRequest, IBaseResource theResource) {
        this.handleUserOperation(theRequest, theResource, RestOperationTypeEnum.CREATE);
    }

    @Override
    public void resourceDeleted(RequestDetails theRequest, IBaseResource theResource) {
        this.handleUserOperation(theRequest, theResource, RestOperationTypeEnum.DELETE);
    }

    @Override
    public void resourceUpdated(RequestDetails theRequest, IBaseResource theResource) {
        this.handleUserOperation(theRequest, theResource, RestOperationTypeEnum.UPDATE);
    }

    public void setDefaultPolicy(PolicyEnum theDefaultPolicy) {
        Validate.notNull((Object)((Object)theDefaultPolicy), (String)"theDefaultPolicy must not be null", (Object[])new Object[0]);
        this.myDefaultPolicy = theDefaultPolicy;
    }

    private static UnsupportedOperationException failForDstu1() {
        return new UnsupportedOperationException("Use of this interceptor on DSTU1 servers is not supportd");
    }

    public static class Verdict {
        private final IAuthRule myDecidingRule;
        private final PolicyEnum myDecision;

        public Verdict(PolicyEnum theDecision, IAuthRule theDecidingRule) {
            this.myDecision = theDecision;
            this.myDecidingRule = theDecidingRule;
        }

        public IAuthRule getDecidingRule() {
            return this.myDecidingRule;
        }

        public PolicyEnum getDecision() {
            return this.myDecision;
        }
    }

    private static enum OperationExamineDirection {
        IN,
        NONE,
        OUT,
        BOTH;

    }
}

