/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.model.dstu.valueset.QuantityCompararatorEnum;
import ca.uhn.fhir.rest.param.BaseParam;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import ca.uhn.fhir.util.CoverageIgnore;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseParamWithPrefix<T extends BaseParam>
extends BaseParam {
    private ParamPrefixEnum myPrefix;

    BaseParamWithPrefix() {
    }

    String extractPrefixAndReturnRest(String theString) {
        int offset;
        for (offset = 0; theString.length() != offset && !Character.isDigit(theString.charAt(offset)); ++offset) {
        }
        String prefix = theString.substring(0, offset);
        this.myPrefix = ParamPrefixEnum.forValue(prefix);
        if (this.myPrefix == null) {
            this.myPrefix = ParamPrefixEnum.forDstu1Value(prefix);
        }
        return theString.substring(offset);
    }

    @Deprecated
    public QuantityCompararatorEnum getComparator() {
        ParamPrefixEnum prefix = this.getPrefix();
        if (prefix == null) {
            return null;
        }
        return QuantityCompararatorEnum.forCode(prefix.getDstu1Value());
    }

    public ParamPrefixEnum getPrefix() {
        return this.myPrefix;
    }

    @Deprecated
    @CoverageIgnore
    public T setComparator(QuantityCompararatorEnum theComparator) {
        this.myPrefix = theComparator != null ? ParamPrefixEnum.forDstu1Value(theComparator.getCode()) : null;
        return (T)this;
    }

    @Deprecated
    @CoverageIgnore
    public T setComparator(String theComparator) {
        this.myPrefix = StringUtils.isNotBlank((CharSequence)theComparator) ? ParamPrefixEnum.forDstu1Value(theComparator) : null;
        return (T)this;
    }

    public T setPrefix(ParamPrefixEnum thePrefix) {
        this.myPrefix = thePrefix;
        return (T)this;
    }
}

