/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.client.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.method.BaseResourceReturningMethodBinding;
import ca.uhn.fhir.rest.method.HttpGetClientInvocation;
import ca.uhn.fhir.rest.method.HttpPostClientInvocation;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.MethodUtil;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.method.SearchParameter;
import ca.uhn.fhir.rest.method.SearchStyleEnum;
import ca.uhn.fhir.rest.param.BaseQueryParameter;
import ca.uhn.fhir.rest.server.IBundleProvider;
import ca.uhn.fhir.rest.server.IRestfulServer;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchMethodBinding
extends BaseResourceReturningMethodBinding {
    private static final Logger ourLog = LoggerFactory.getLogger(SearchMethodBinding.class);
    private String myCompartmentName;
    private String myDescription;
    private Integer myIdParamIndex;
    private String myQueryName;
    private boolean myAllowUnknownParams;

    public SearchMethodBinding(Class<? extends IBaseResource> theReturnResourceType, Method theMethod, FhirContext theContext, Object theProvider) {
        super(theReturnResourceType, theMethod, theContext, theProvider);
        Search search = theMethod.getAnnotation(Search.class);
        this.myQueryName = (String)StringUtils.defaultIfBlank((CharSequence)search.queryName(), null);
        this.myCompartmentName = (String)StringUtils.defaultIfBlank((CharSequence)search.compartmentName(), null);
        this.myIdParamIndex = MethodUtil.findIdParameterIndex(theMethod, this.getContext());
        this.myAllowUnknownParams = search.allowUnknownParams();
        Description desc = theMethod.getAnnotation(Description.class);
        if (desc != null) {
            this.myDescription = StringUtils.isNotBlank((CharSequence)desc.formalDefinition()) ? (String)StringUtils.defaultIfBlank((CharSequence)desc.formalDefinition(), null) : (String)StringUtils.defaultIfBlank((CharSequence)desc.shortDefinition(), null);
        }
        List<IParameter> parameters = this.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            SearchParameter sp;
            IParameter next = parameters.get(i);
            if (!(next instanceof SearchParameter) || !(sp = (SearchParameter)next).getName().startsWith("_") || !ALLOWED_PARAMS.contains(sp.getName())) continue;
            String msg = this.getContext().getLocalizer().getMessage(this.getClass().getName() + ".invalidSpecialParamName", theMethod.getName(), theMethod.getDeclaringClass().getSimpleName(), sp.getName());
            throw new ConfigurationException(msg);
        }
        if (StringUtils.isBlank((CharSequence)this.myCompartmentName) && this.myIdParamIndex != null) {
            String msg = theContext.getLocalizer().getMessage(this.getClass().getName() + ".idWithoutCompartment", theMethod.getName(), theMethod.getDeclaringClass());
            throw new ConfigurationException(msg);
        }
    }

    public String getDescription() {
        return this.myDescription;
    }

    @Override
    public RestOperationTypeEnum getRestOperationType() {
        return RestOperationTypeEnum.SEARCH_TYPE;
    }

    @Override
    protected BundleTypeEnum getResponseBundleType() {
        return BundleTypeEnum.SEARCHSET;
    }

    @Override
    public BaseResourceReturningMethodBinding.ReturnTypeEnum getReturnType() {
        return BaseResourceReturningMethodBinding.ReturnTypeEnum.BUNDLE;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean incomingServerRequestMatchesMethod(RequestDetails theRequest) {
        HashSet<String> methodParamsTemp;
        block19: {
            Object queryNameValues;
            if (theRequest.getId() != null && this.myIdParamIndex == null) {
                ourLog.trace("Method {} doesn't match because ID is not null: {}", (Object)theRequest.getId());
                return false;
            }
            if (theRequest.getRequestType() == RequestTypeEnum.GET && theRequest.getOperation() != null && !"_search".equals(theRequest.getOperation())) {
                ourLog.trace("Method {} doesn't match because request type is GET but operation is not null: {}", (Object)theRequest.getId(), (Object)theRequest.getOperation());
                return false;
            }
            if (theRequest.getRequestType() == RequestTypeEnum.POST && !"_search".equals(theRequest.getOperation())) {
                ourLog.trace("Method {} doesn't match because request type is POST but operation is not _search: {}", (Object)theRequest.getId(), (Object)theRequest.getOperation());
                return false;
            }
            if (theRequest.getRequestType() != RequestTypeEnum.GET && theRequest.getRequestType() != RequestTypeEnum.POST) {
                ourLog.trace("Method {} doesn't match because request type is {}", (Object)this.getMethod());
                return false;
            }
            if (!StringUtils.equals((CharSequence)this.myCompartmentName, (CharSequence)theRequest.getCompartmentName())) {
                ourLog.trace("Method {} doesn't match because it is for compartment {} but request is compartment {}", new Object[]{this.getMethod(), this.myCompartmentName, theRequest.getCompartmentName()});
                return false;
            }
            methodParamsTemp = new HashSet<String>();
            Set<String> unqualifiedNames = theRequest.getUnqualifiedToQualifiedNames().keySet();
            Set<String> qualifiedParamNames = theRequest.getParameters().keySet();
            for (int i = 0; i < this.getParameters().size(); ++i) {
                List<String> qualifiedNames;
                QualifierDetails qualifiers;
                if (!(this.getParameters().get(i) instanceof BaseQueryParameter)) continue;
                BaseQueryParameter temp = (BaseQueryParameter)this.getParameters().get(i);
                String name = temp.getName();
                if (temp.isRequired()) {
                    if (qualifiedParamNames.contains(name) && (qualifiers = SearchMethodBinding.extractQualifiersFromParameterName(name)).passes(temp.getQualifierWhitelist(), temp.getQualifierBlacklist())) {
                        methodParamsTemp.add(name);
                    }
                    if (unqualifiedNames.contains(name)) {
                        qualifiedNames = theRequest.getUnqualifiedToQualifiedNames().get(name);
                        qualifiedNames = this.processWhitelistAndBlacklist(qualifiedNames, temp.getQualifierWhitelist(), temp.getQualifierBlacklist());
                        methodParamsTemp.addAll(qualifiedNames);
                    }
                    if (qualifiedParamNames.contains(name) || unqualifiedNames.contains(name)) continue;
                    ourLog.trace("Method {} doesn't match param '{}' is not present", (Object)this.getMethod().getName(), (Object)name);
                    return false;
                }
                if (qualifiedParamNames.contains(name) && (qualifiers = SearchMethodBinding.extractQualifiersFromParameterName(name)).passes(temp.getQualifierWhitelist(), temp.getQualifierBlacklist())) {
                    methodParamsTemp.add(name);
                }
                if (unqualifiedNames.contains(name)) {
                    qualifiedNames = theRequest.getUnqualifiedToQualifiedNames().get(name);
                    qualifiedNames = this.processWhitelistAndBlacklist(qualifiedNames, temp.getQualifierWhitelist(), temp.getQualifierBlacklist());
                    methodParamsTemp.addAll(qualifiedNames);
                }
                if (qualifiedParamNames.contains(name) || qualifiedParamNames.contains(name)) continue;
                methodParamsTemp.add(name);
            }
            if (this.myQueryName != null) {
                queryNameValues = theRequest.getParameters().get("_query");
                if (queryNameValues != null && StringUtils.isNotBlank((CharSequence)queryNameValues[0])) {
                    Object queryName = queryNameValues[0];
                    if (!this.myQueryName.equals(queryName)) {
                        ourLog.trace("Query name does not match {}", (Object)this.myQueryName);
                        return false;
                    }
                    methodParamsTemp.add("_query");
                    break block19;
                } else {
                    ourLog.trace("Query name does not match {}", (Object)this.myQueryName);
                    return false;
                }
            }
            queryNameValues = theRequest.getParameters().get("_query");
            if (queryNameValues != null && StringUtils.isNotBlank((CharSequence)queryNameValues[0])) {
                ourLog.trace("Query has name");
                return false;
            }
        }
        for (String next : theRequest.getParameters().keySet()) {
            if (!ALLOWED_PARAMS.contains(next)) continue;
            methodParamsTemp.add(next);
        }
        Set<String> keySet = theRequest.getParameters().keySet();
        if (!this.myAllowUnknownParams) {
            for (String next : keySet) {
                if (methodParamsTemp.contains(next)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public BaseHttpClientInvocation invokeClient(Object[] theArgs) throws InternalErrorException {
        assert (this.myQueryName == null || (theArgs != null ? theArgs.length : 0) == this.getParameters().size()) : "Wrong number of arguments: " + (theArgs != null ? Integer.valueOf(theArgs.length) : "null");
        LinkedHashMap<String, List<String>> queryStringArgs = new LinkedHashMap<String, List<String>>();
        if (this.myQueryName != null) {
            queryStringArgs.put("_query", Collections.singletonList(this.myQueryName));
        }
        IdDt id = (IdDt)(this.myIdParamIndex != null ? theArgs[this.myIdParamIndex] : null);
        String resourceName = this.getResourceName();
        if (theArgs != null) {
            for (int idx = 0; idx < theArgs.length; ++idx) {
                IParameter nextParam = this.getParameters().get(idx);
                nextParam.translateClientArgumentIntoQueryArgument(this.getContext(), theArgs[idx], queryStringArgs, null);
            }
        }
        BaseHttpClientInvocation retVal = SearchMethodBinding.createSearchInvocation(this.getContext(), resourceName, queryStringArgs, id, this.myCompartmentName, null);
        return retVal;
    }

    public IBundleProvider invokeServer(IRestfulServer theServer, RequestDetails theRequest, Object[] theMethodParams) throws InvalidRequestException, InternalErrorException {
        if (this.myIdParamIndex != null) {
            theMethodParams[this.myIdParamIndex.intValue()] = theRequest.getId();
        }
        Object response = this.invokeServerMethod(theServer, theRequest, theMethodParams);
        return this.toResourceList(response);
    }

    @Override
    protected boolean isAddContentLocationHeader() {
        return false;
    }

    private List<String> processWhitelistAndBlacklist(List<String> theQualifiedNames, Set<String> theQualifierWhitelist, Set<String> theQualifierBlacklist) {
        if (theQualifierWhitelist == null && theQualifierBlacklist == null) {
            return theQualifiedNames;
        }
        ArrayList<String> retVal = new ArrayList<String>(theQualifiedNames.size());
        for (String next : theQualifiedNames) {
            QualifierDetails qualifiers = SearchMethodBinding.extractQualifiersFromParameterName(next);
            if (!qualifiers.passes(theQualifierWhitelist, theQualifierBlacklist)) continue;
            retVal.add(next);
        }
        return retVal;
    }

    public String toString() {
        return this.getMethod().toString();
    }

    public static BaseHttpClientInvocation createSearchInvocation(FhirContext theContext, String theResourceName, Map<String, List<String>> theParameters, IdDt theId, String theCompartmentName, SearchStyleEnum theSearchStyle) {
        BaseHttpClientInvocation invocation;
        SearchStyleEnum searchStyle = theSearchStyle;
        if (searchStyle == null) {
            int length = 0;
            for (Map.Entry<String, List<String>> nextEntry : theParameters.entrySet()) {
                length += nextEntry.getKey().length();
                for (String next : nextEntry.getValue()) {
                    length += next.length();
                }
            }
            searchStyle = length < 5000 ? SearchStyleEnum.GET : SearchStyleEnum.POST;
        }
        boolean compartmentSearch = false;
        if (theCompartmentName != null) {
            if (theId == null || !theId.hasIdPart()) {
                String msg = theContext.getLocalizer().getMessage(SearchMethodBinding.class.getName() + ".idNullForCompartmentSearch", new Object[0]);
                throw new InvalidRequestException(msg);
            }
            compartmentSearch = true;
        }
        switch (searchStyle) {
            default: {
                if (compartmentSearch) {
                    invocation = new HttpGetClientInvocation(theContext, theParameters, theResourceName, theId.getIdPart(), theCompartmentName);
                    break;
                }
                invocation = new HttpGetClientInvocation(theContext, theParameters, theResourceName);
                break;
            }
            case GET_WITH_SEARCH: {
                if (compartmentSearch) {
                    invocation = new HttpGetClientInvocation(theContext, theParameters, theResourceName, theId.getIdPart(), theCompartmentName, "_search");
                    break;
                }
                invocation = new HttpGetClientInvocation(theContext, theParameters, theResourceName, "_search");
                break;
            }
            case POST: {
                invocation = compartmentSearch ? new HttpPostClientInvocation(theContext, theParameters, theResourceName, theId.getIdPart(), theCompartmentName, "_search") : new HttpPostClientInvocation(theContext, theParameters, theResourceName, "_search");
            }
        }
        return invocation;
    }

    public static QualifierDetails extractQualifiersFromParameterName(String theParamName) {
        QualifierDetails retVal = new QualifierDetails();
        if (theParamName == null || theParamName.length() == 0) {
            return retVal;
        }
        int dotIdx = -1;
        int colonIdx = -1;
        for (int idx = 0; idx < theParamName.length(); ++idx) {
            char nextChar = theParamName.charAt(idx);
            if (nextChar == '.' && dotIdx == -1) {
                dotIdx = idx;
                continue;
            }
            if (nextChar != ':' || colonIdx != -1) continue;
            colonIdx = idx;
        }
        if (dotIdx != -1 && colonIdx != -1) {
            if (dotIdx < colonIdx) {
                retVal.setDotQualifier(theParamName.substring(dotIdx, colonIdx));
                retVal.setColonQualifier(theParamName.substring(colonIdx));
            } else {
                retVal.setColonQualifier(theParamName.substring(colonIdx, dotIdx));
                retVal.setDotQualifier(theParamName.substring(dotIdx));
            }
        } else if (dotIdx != -1) {
            retVal.setDotQualifier(theParamName.substring(dotIdx));
        } else if (colonIdx != -1) {
            retVal.setColonQualifier(theParamName.substring(colonIdx));
        }
        return retVal;
    }

    public static BaseHttpClientInvocation createSearchInvocation(FhirContext theContext, String theSearchUrl, Map<String, List<String>> theParams) {
        return new HttpGetClientInvocation(theContext, theParams, theSearchUrl);
    }

    public static class QualifierDetails {
        private String myColonQualifier;
        private String myDotQualifier;

        public boolean passes(Set<String> theQualifierWhitelist, Set<String> theQualifierBlacklist) {
            if (theQualifierWhitelist != null && !theQualifierWhitelist.contains(".*") && (this.myDotQualifier != null ? !theQualifierWhitelist.contains(this.myDotQualifier) : !theQualifierWhitelist.contains("."))) {
                return false;
            }
            if (theQualifierBlacklist != null) {
                if (this.myDotQualifier != null && theQualifierBlacklist.contains(this.myDotQualifier)) {
                    return false;
                }
                if (this.myColonQualifier != null && theQualifierBlacklist.contains(this.myColonQualifier)) {
                    return false;
                }
            }
            return true;
        }

        public void setColonQualifier(String theColonQualifier) {
            this.myColonQualifier = theColonQualifier;
        }

        public void setDotQualifier(String theDotQualifier) {
            this.myDotQualifier = theDotQualifier;
        }
    }
}

