/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.rest.annotation.Patch;
import ca.uhn.fhir.rest.annotation.ResourceParam;
import ca.uhn.fhir.rest.api.PatchTypeEnum;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.client.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.method.BaseOutcomeReturningMethodBindingWithResourceIdButNoResourceBody;
import ca.uhn.fhir.rest.method.HttpPatchClientInvocation;
import ca.uhn.fhir.rest.method.HttpPostClientInvocation;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.MethodUtil;
import ca.uhn.fhir.rest.method.PatchTypeParameter;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.method.UpdateMethodBinding;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IIdType;

public class PatchMethodBinding
extends BaseOutcomeReturningMethodBindingWithResourceIdButNoResourceBody {
    private int myPatchTypeParameterIndex = -1;
    private int myResourceParamIndex;

    public PatchMethodBinding(Method theMethod, FhirContext theContext, Object theProvider) {
        super(theMethod, theContext, theProvider, Patch.class, theMethod.getAnnotation(Patch.class).type());
        ListIterator<Class<?>> iter = Arrays.asList(theMethod.getParameterTypes()).listIterator();
        while (iter.hasNext()) {
            int nextIndex = iter.nextIndex();
            Class<?> next = iter.next();
            if (next.equals(PatchTypeEnum.class)) {
                this.myPatchTypeParameterIndex = nextIndex;
            }
            for (Annotation nextAnnotation : theMethod.getParameterAnnotations()[nextIndex]) {
                if (!(nextAnnotation instanceof ResourceParam)) continue;
                this.myResourceParamIndex = nextIndex;
            }
        }
        if (this.myPatchTypeParameterIndex == -1) {
            throw new ConfigurationException("Method has no parameter of type " + PatchTypeEnum.class.getName() + " - " + theMethod.toString());
        }
        if (this.myResourceParamIndex == -1) {
            throw new ConfigurationException("Method has no parameter with @" + ResourceParam.class.getSimpleName() + " annotation - " + theMethod.toString());
        }
    }

    @Override
    public boolean incomingServerRequestMatchesMethod(RequestDetails theRequest) {
        boolean retVal = super.incomingServerRequestMatchesMethod(theRequest);
        if (retVal) {
            PatchTypeParameter.getTypeForRequestOrThrowInvalidRequestException(theRequest);
        }
        return retVal;
    }

    @Override
    public RestOperationTypeEnum getRestOperationType() {
        return RestOperationTypeEnum.PATCH;
    }

    @Override
    protected Set<RequestTypeEnum> provideAllowableRequestTypes() {
        return Collections.singleton(RequestTypeEnum.PATCH);
    }

    @Override
    protected BaseHttpClientInvocation createClientInvocation(Object[] theArgs, IResource theResource) {
        StringBuilder urlExtension = new StringBuilder();
        urlExtension.append(this.getContext().getResourceDefinition(theResource).getName());
        return new HttpPostClientInvocation(this.getContext(), theResource, urlExtension.toString());
    }

    @Override
    protected boolean allowVoidReturnType() {
        return true;
    }

    @Override
    public BaseHttpClientInvocation invokeClient(Object[] theArgs) throws InternalErrorException {
        IIdType idDt = (IIdType)theArgs[this.getIdParameterIndex()];
        if (idDt == null) {
            throw new NullPointerException("ID can not be null");
        }
        if (!idDt.hasResourceType()) {
            idDt = idDt.withResourceType(this.getResourceName());
        } else if (!this.getResourceName().equals(idDt.getResourceType())) {
            throw new InvalidRequestException("ID parameter has the wrong resource type, expected '" + this.getResourceName() + "', found: " + idDt.getResourceType());
        }
        PatchTypeEnum patchType = (PatchTypeEnum)((Object)theArgs[this.myPatchTypeParameterIndex]);
        String body = (String)theArgs[this.myResourceParamIndex];
        HttpPatchClientInvocation retVal = PatchMethodBinding.createPatchInvocation(this.getContext(), idDt, patchType, body);
        for (int idx = 0; idx < theArgs.length; ++idx) {
            IParameter nextParam = this.getParameters().get(idx);
            nextParam.translateClientArgumentIntoQueryArgument(this.getContext(), theArgs[idx], null, null);
        }
        return retVal;
    }

    public static HttpPatchClientInvocation createPatchInvocation(FhirContext theContext, IIdType theId, PatchTypeEnum thePatchType, String theBody) {
        HttpPatchClientInvocation retVal = new HttpPatchClientInvocation(theContext, theId, thePatchType.getContentType(), theBody);
        return retVal;
    }

    public static HttpPatchClientInvocation createPatchInvocation(FhirContext theContext, String theUrlPath, PatchTypeEnum thePatchType, String theBody) {
        HttpPatchClientInvocation retVal = new HttpPatchClientInvocation(theContext, theUrlPath, thePatchType.getContentType(), theBody);
        return retVal;
    }

    @Override
    protected void addParametersForServerRequest(RequestDetails theRequest, Object[] theParams) {
        IIdType id = theRequest.getId();
        id = UpdateMethodBinding.applyETagAsVersion(theRequest, id);
        theParams[this.getIdParameterIndex().intValue()] = id;
    }

    @Override
    protected String getMatchingOperation() {
        return null;
    }

    public static HttpPatchClientInvocation createPatchInvocation(FhirContext theContext, PatchTypeEnum thePatchType, String theBody, String theResourceType, Map<String, List<String>> theMatchParams) {
        StringBuilder urlBuilder = MethodUtil.createUrl(theResourceType, theMatchParams);
        String url = urlBuilder.toString();
        HttpPatchClientInvocation retVal = new HttpPatchClientInvocation(theContext, url, thePatchType.getContentType(), theBody);
        return retVal;
    }
}

