/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.client.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.server.EncodingEnum;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HttpGetClientInvocation
extends BaseHttpClientInvocation {
    private final Map<String, List<String>> myParameters;
    private final String myUrlPath;

    public HttpGetClientInvocation(FhirContext theContext, Map<String, List<String>> theParameters, String ... theUrlFragments) {
        super(theContext);
        this.myParameters = theParameters;
        this.myUrlPath = StringUtils.join((Object[])theUrlFragments, (char)'/');
    }

    public HttpGetClientInvocation(FhirContext theContext, Map<String, List<String>> theParameters, List<String> theUrlFragments) {
        super(theContext);
        this.myParameters = theParameters;
        this.myUrlPath = StringUtils.join(theUrlFragments, (char)'/');
    }

    public HttpGetClientInvocation(FhirContext theContext, String theUrlPath) {
        super(theContext);
        this.myParameters = new HashMap<String, List<String>>();
        this.myUrlPath = theUrlPath;
    }

    public HttpGetClientInvocation(FhirContext theContext, String ... theUrlFragments) {
        super(theContext);
        this.myParameters = new HashMap<String, List<String>>();
        this.myUrlPath = StringUtils.join((Object[])theUrlFragments, (char)'/');
    }

    public HttpGetClientInvocation(FhirContext theContext, List<String> theUrlFragments) {
        super(theContext);
        this.myParameters = new HashMap<String, List<String>>();
        this.myUrlPath = StringUtils.join(theUrlFragments, (char)'/');
    }

    public Map<String, List<String>> getParameters() {
        return this.myParameters;
    }

    public String getUrlPath() {
        return this.myUrlPath;
    }

    @Override
    public IHttpRequest asHttpRequest(String theUrlBase, Map<String, List<String>> theExtraParams, EncodingEnum theEncoding, Boolean thePrettyPrint) {
        StringBuilder b = new StringBuilder();
        if (!this.myUrlPath.contains("://")) {
            b.append(theUrlBase);
            if (!theUrlBase.endsWith("/")) {
                b.append('/');
            }
        }
        b.append(this.myUrlPath);
        boolean first = b.indexOf("?") == -1;
        for (Map.Entry<String, List<String>> next : this.myParameters.entrySet()) {
            if (next.getValue() == null || next.getValue().isEmpty()) continue;
            String nextKey = next.getKey();
            for (String nextValue : next.getValue()) {
                first = this.addQueryParameter(b, first, nextKey, nextValue);
            }
        }
        HttpGetClientInvocation.appendExtraParamsWithQuestionMark(theExtraParams, b, first);
        return super.createHttpRequest(b.toString(), theEncoding, RequestTypeEnum.GET);
    }

    private boolean addQueryParameter(StringBuilder b, boolean first, String nextKey, String nextValue) {
        boolean retVal = first;
        if (retVal) {
            b.append('?');
            retVal = false;
        } else {
            b.append('&');
        }
        try {
            b.append(URLEncoder.encode(nextKey, "UTF-8"));
            b.append('=');
            b.append(URLEncoder.encode(nextValue, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ConfigurationException("Could not find UTF-8 encoding. This shouldn't happen.", e);
        }
        return retVal;
    }
}

